package beanPkg;

import java.sql.*;
import java.util.Date;
import java.text.SimpleDateFormat;

public class DBConn {
	private Connection conn;
	private static final String dburl="jdbc:mysql:///";
	private String dbName;
	
	public DBConn(String s){
		dbName=s;
	}
	
	private void openDB() throws Exception {
		Class.forName("com.mysql.jdbc.Driver").newInstance();
		conn=DriverManager.getConnection(dburl+dbName,"root","");
	}
	
	private void closeDB() throws Exception{
		conn.close();
	}
	
	public String getAnimals() {
		try {
			openDB();
			String qstr = String.format("SELECT animalID, animalName FROM Animals");
			Statement statement = conn.createStatement();
			ResultSet resultset = statement.executeQuery(qstr);
	
			String list = "<select name='animalID'>\n<option value='0'>Not Applicable</option>\n";
			while(resultset.next()){
				int animalID = resultset.getInt("animalID");
				String animalName = resultset.getString("animalName");
	
				String nextItem =String.format("<option value='%d'>%s</option>\n", animalID, animalName);
				list += nextItem;
			}
			
			list += "</select>";
			closeDB();
			return list;
		} catch (Exception e) {
			return "";
		}
	}
	
	public String addCustomer(String firstName, String lastName, String birthday, String phone, String street, 
			String city, String postalCode, String province, String country, String animalID, String under48) {
		
		if(under48==null) {
			under48 = "0";
		}
		
		try {
			openDB();
			Statement statement = conn.createStatement();
			String qstr;
			ResultSet resultset;
			
			//Create new address record
			qstr = String.format("INSERT INTO Addresses (street, city, postalCode, province, country) values('%s','%s','%s','%s','%s');", street, city, postalCode, province, country);
			statement.execute(qstr);
			
			//Get the last inserted addressID
			qstr = "SELECT addressID FROM Addresses ORDER BY addressID DESC LIMIT 1";
			resultset = statement.executeQuery(qstr);
			resultset.next();
			int addressID = resultset.getInt("addressID");
			
			//Create new people record
			qstr = String.format("INSERT INTO People (lastName, firstName, dateOfBirth, phone, addressID) values('%s','%s','%s','%s','%d');", lastName, firstName, birthday, phone, addressID);
			statement.execute(qstr);
			
			//Get the last inserted PeopleID
			qstr = "SELECT peopleID FROM People ORDER BY peopleID DESC LIMIT 1";
			resultset = statement.executeQuery(qstr);
			resultset.next();
			int peopleID = resultset.getInt("peopleID");

			//Create new customer record
			qstr = String.format("INSERT INTO Customers (peopleID, under48Inches) values('%d','%s');", peopleID, under48);
			statement.execute(qstr);
			
			//Get the last inserted customerID
			qstr = "SELECT customerID FROM Customers ORDER BY customerID DESC LIMIT 1";
			resultset = statement.executeQuery(qstr);
			resultset.next();
			String customerID = resultset.getString("customerID");
			
			//Create PeopleAnimalAllergies record
			qstr = String.format("INSERT INTO PeopleAnimalAllergies (animalID, peopleID) values('%s','%d');", animalID, peopleID);
			statement = conn.createStatement();
			statement.execute(qstr);
			
			closeDB();
			
			return customerID;
		} catch (Exception e) {
			System.out.println(e.toString());
			return "";
		}
	}
	
	public void addStaffMember(String firstName, String lastName, String birthday, String phone, String street, String city, 
			String postalCode, String province, String country, String userName, String password, String departmentID) {
		try {
			openDB();
			Statement statement = conn.createStatement();
			String qstr;
			ResultSet resultset;
			
			//Create new address record
			qstr = String.format("INSERT INTO Addresses (street, city, postalCode, province, country) values('%s','%s','%s','%s','%s');", street, city, postalCode, province, country);
			statement.execute(qstr);
			
			//Get the last inserted addressID
			qstr = "SELECT addressID FROM Addresses ORDER BY addressID DESC LIMIT 1";
			resultset = statement.executeQuery(qstr);
			resultset.next();
			int addressID = resultset.getInt("addressID");
			
			//Create new people record
			qstr = String.format("INSERT INTO People (lastName, firstName, dateOfBirth, phone, addressID) values('%s','%s','%s','%s','%d');", lastName, firstName, birthday, phone, addressID);
			statement.execute(qstr);
			
			//Get the last inserted PeopleID
			qstr = "SELECT peopleID FROM People ORDER BY peopleID DESC LIMIT 1";
			resultset = statement.executeQuery(qstr);
			resultset.next();
			int peopleID = resultset.getInt("peopleID");
			String userType = "staff";

			//Create new StaffPeople record
			qstr = String.format("INSERT INTO StaffPeople (staffDepartmentID, peopleID, userName, password, userType) values('%s','%s','%s','%s','%s');", departmentID, peopleID, userName, password, userType);
			statement.execute(qstr);
			closeDB();
		} catch (Exception e) {
			System.out.println(e.toString());
		}
	}
	
	public String searchCustomers(String firstName, String lastName, String birthday, String phone, String street, 
			String city, String postalCode, String province, String country, String under48) {
		
		boolean first=true;
		String criteria="SELECT c.customerID, p.firstName, p.lastName, c.under48Inches, p.dateOfBirth, p.phone, " +
				"a.street, a.city, a.postalCode, a.province, a.country " +
				"FROM Customers c " +
				"JOIN People p " +
				"ON c.peopleID=p.peopleID " +
				"JOIN Addresses a " +
				"ON p.addressID=a.addressID ";
		
		//First Name criterion
		if(first==true&&!firstName.equals("")) {
			criteria += "WHERE p.firstName LIKE '"+firstName+"%' ";
			first=false;
		} else if(!firstName.equals("")) {
			criteria += "AND p.firstName LIKE '"+firstName+"%' ";
		}
		
		//Last Name criterion
		if(first==true&&!lastName.equals("")) {
			criteria += "WHERE p.lastName LIKE '"+lastName+"%' ";
			first=false;
		} else if(!lastName.equals("")) {
			criteria += "AND p.lastName LIKE '"+lastName+"%' ";
		}
		
		//Date of birth criterion
		if(first==true&&!birthday.equals("")) {
			criteria += "WHERE p.dateOfBirth='"+birthday+"' ";
			first=false;
		} else if(!birthday.equals("")) {
			criteria += "AND p.dateOfBirth='"+birthday+"' ";
		}
		
		//Phone criterion
		if(first==true&&!phone.equals("")) {
			criteria += "WHERE p.phone='"+phone+"' ";
			first=false;
		} else if(!phone.equals("")) {
			criteria += "AND p.phone='"+phone+"' ";
		}
		
		//Format under48
		if(under48==null) {
			under48 = "0";
		}
		
		//Under48 criterion
		if(first==true&&under48.equals("1")) {
			criteria += "WHERE c.under48Inches='1' ";
			first=false;
		} else if(under48.equals("1")) {
			criteria += "AND c.under48Inches='1' ";
		}
		
		//Street criterion
		if(first==true&&!street.equals("")) {
			criteria += "WHERE a.street LIKE '"+street+"%' ";
			first=false;
		} else if(!street.equals("")) {
			criteria += "AND a.street LIKE '"+street+"%' ";
		}
		
		//City criterion
		if(first==true&&!city.equals("")) {
			criteria += "WHERE a.city LIKE '"+city+"%' ";
			first=false;
		} else if(!city.equals("")) {
			criteria += "AND a.city LIKE '"+city+"%' ";
		}
		
		//PostalCode criterion
		if(first==true&&!postalCode.equals("")) {
			criteria += "WHERE a.postalCode='"+postalCode+"' ";
			first=false;
		} else if(!postalCode.equals("")) {
			criteria += "AND a.postalCode='"+postalCode+"' ";
		}
		
		//Province criterion
		if(first==true&&!province.equals("")) {
			criteria += "WHERE a.province LIKE '"+province+"%' ";
			first=false;
		} else if(!province.equals("")) {
			criteria += "AND a.province LIKE '"+province+"%' ";
		}
		
		//Country criterion
		if(first==true&&!country.equals("")) {
			criteria += "WHERE a.country LIKE '"+country+"%' ";
			first=false;
		} else if(!country.equals("")) {
			criteria += "AND a.country LIKE '"+country+"%' ";
		}
		
		String results="";
		
		try {
			openDB();
			Statement statement = conn.createStatement();
			ResultSet resultset = statement.executeQuery(criteria);
			
			results= "<table width='400' cellpadding='0' cellspacing='0'>";
			while(resultset.next()){
				String customerID = resultset.getString("customerID");
				firstName = resultset.getString("firstName");
				lastName = resultset.getString("lastName");
				under48 = resultset.getString("under48Inches");
				birthday = resultset.getString("dateOfBirth");
				phone = resultset.getString("phone");
				street = resultset.getString("street");
				city = resultset.getString("city");
				postalCode = resultset.getString("postalCode");
				province = resultset.getString("province");
				country = resultset.getString("country");
				
				if(under48.equals("0")) {
					under48 = "No";
				} else {
					under48 = "Yes";
				}
	
				String nextItem =String.format("<tr><td width='200'><b>ID:</b> %s</td><td width='200'><b>%s %s</b></td></tr>" +
											   "<tr><td><b>Birthday:</b> %s</td><td><b>Phone:</b> %s</td><td></td></tr>" +
											   "<tr><td colspan='2'><b>Under 48 Inches:</b> %s</td></tr>" +
											   "<tr><td colspan='2'><b>Address:</b><br>%s<br>%s<br>%s<br>%s<br>%s<br></td></tr>" +
											   "<tr><td colspan='2'>" +
											   "<form action='sell-ticket-confirm.jsp' name='"+customerID+"'>" +
											   "<input class='form' type='hidden' name='customerID' value='%s' />" +
											   "<b>Attraction:</b> " + getAttractions() + " <input class='button' type='submit' value='Quick Sell'></form><br><br>" +
											   "</td></tr>", 
						customerID, firstName, lastName, birthday, phone, under48, street, city, province, postalCode, country, customerID);
				results += nextItem;
			}
			results+="</table>";
			
			closeDB();
			return results;
		} catch (Exception e) {
			System.out.println(e.toString());
			return "";
		}
	}
	
	public String searchStaff(String firstName, String lastName, String department, String birthday, String phone, String street, 
			String city, String postalCode, String province, String country) {
		
		boolean first=true;
		String criteria="SELECT sp.staffPeopleID, p.firstName, p.lastName, p.dateOfBirth, p.phone, " +
				"a.street, a.city, a.postalCode, a.province, a.country, sd.departmentName " +
				"FROM StaffPeople sp " +
				"JOIN People p " +
				"ON sp.peopleID=p.peopleID " +
				"JOIN Addresses a " +
				"ON p.addressID=a.addressID " +
				"JOIN StaffDepartments sd " +
				"ON sd.staffDepartmentID=sp.staffDepartmentID ";
		
		//First Name criterion
		if(first==true&&!firstName.equals("")) {
			criteria += "WHERE p.firstName LIKE '"+firstName+"%' ";
			first=false;
		} else if(!firstName.equals("")) {
			criteria += "AND p.firstName LIKE '"+firstName+"%' ";
		}
		
		//Last Name criterion
		if(first==true&&!lastName.equals("")) {
			criteria += "WHERE p.lastName LIKE '"+lastName+"%' ";
			first=false;
		} else if(!lastName.equals("")) {
			criteria += "AND p.lastName LIKE '"+lastName+"%' ";
		}
		
		//Department criterion
		if(first==true&&!department.equals("")) {
			criteria += "WHERE sd.staffDepartmentID='"+department+"' ";
			first=false;
		} else if(!department.equals("")) {
			criteria += "AND sd.staffDepartmentID='"+department+"' ";
		}
		
		//Date of birth criterion
		if(first==true&&!birthday.equals("")) {
			criteria += "WHERE p.dateOfBirth='"+birthday+"' ";
			first=false;
		} else if(!birthday.equals("")) {
			criteria += "AND p.dateOfBirth='"+birthday+"' ";
		}
		
		//Phone criterion
		if(first==true&&!phone.equals("")) {
			criteria += "WHERE p.phone='"+phone+"' ";
			first=false;
		} else if(!phone.equals("")) {
			criteria += "AND p.phone='"+phone+"' ";
		}
		
		//Street criterion
		if(first==true&&!street.equals("")) {
			criteria += "WHERE a.street LIKE '"+street+"%' ";
			first=false;
		} else if(!street.equals("")) {
			criteria += "AND a.street LIKE '"+street+"%' ";
		}
		
		//City criterion
		if(first==true&&!city.equals("")) {
			criteria += "WHERE a.city LIKE '"+city+"%' ";
			first=false;
		} else if(!city.equals("")) {
			criteria += "AND a.city LIKE '"+city+"%' ";
		}
		
		//PostalCode criterion
		if(first==true&&!postalCode.equals("")) {
			criteria += "WHERE a.postalCode='"+postalCode+"' ";
			first=false;
		} else if(!postalCode.equals("")) {
			criteria += "AND a.postalCode='"+postalCode+"' ";
		}
		
		//Province criterion
		if(first==true&&!province.equals("")) {
			criteria += "WHERE a.province LIKE '"+province+"%' ";
			first=false;
		} else if(!province.equals("")) {
			criteria += "AND a.province LIKE '"+province+"%' ";
		}
		
		//Country criterion
		if(first==true&&!country.equals("")) {
			criteria += "WHERE a.country LIKE '"+country+"%' ";
			first=false;
		} else if(!country.equals("")) {
			criteria += "AND a.country LIKE '"+country+"%' ";
		}
		
		String results="";
		
		try {
			openDB();
			Statement statement = conn.createStatement();
			ResultSet resultset = statement.executeQuery(criteria);
			
			results= criteria+"<br><br><table width='400' cellpadding='0' cellspacing='0'>";
			while(resultset.next()){
				String staffPeopleID = resultset.getString("staffPeopleID");
				firstName = resultset.getString("firstName");
				lastName = resultset.getString("lastName");
				department = resultset.getString("departmentName");
				birthday = resultset.getString("dateOfBirth");
				phone = resultset.getString("phone");
				street = resultset.getString("street");
				city = resultset.getString("city");
				postalCode = resultset.getString("postalCode");
				province = resultset.getString("province");
				country = resultset.getString("country");
	
				String nextItem =String.format("<tr><td width='200'><b>ID:</b> %s</td><td width='200'><b>%s %s</b></td></tr>" +
											   "<tr><td><b>Birthday:</b> %s</td><td><b>Phone:</b> %s</td><td></td></tr>" +
											   "<tr><td colspan='2'><b>Department:</b> %s</td></tr>" +
											   "<tr><td colspan='2'><b>Address:</b><br>%s<br>%s<br>%s<br>%s<br>%s<br><br></td></tr>", 
						staffPeopleID, firstName, lastName, birthday, phone, department, street, city, province, postalCode, country);
				results += nextItem;
			}
			results+="</table>";
			
			closeDB();
			return results;
		} catch (Exception e) {
			System.out.println(e.toString());
			return "";
		}
	}
	
	public String getDepartments() {
		try {
			openDB();
			String qstr = String.format("SELECT staffDepartmentID, departmentName FROM StaffDepartments");
			Statement statement = conn.createStatement();
			ResultSet resultset = statement.executeQuery(qstr);
	
			String list = "<select name='departmentID'>";
			while(resultset.next()){
				int departmentID = resultset.getInt("staffDepartmentID");
				String departmentName = resultset.getString("departmentName");
	
				String nextItem =String.format("<option value='%d'>%s</option>\n", departmentID, departmentName);
				list += nextItem;
			}
			
			list += "</select>";
			closeDB();
			return list;
		} catch (Exception e) {
			return "";
		}
	}
	
	public String getAttractionsByAge(String age) {
		try {
			openDB();
			String qstr = String.format("SELECT attractionName, inOperation, capacity, cost, under48InchesAllowed, minimumAge, averageLineUp FROM Attractions WHERE minimumAge<=%s", age);
			Statement statement = conn.createStatement();
			ResultSet resultset = statement.executeQuery(qstr);
	
			String list = "";
			while(resultset.next()){
				String attractionName = resultset.getString("attractionName");
				String inOperation = resultset.getString("inOperation");
				String capacity = resultset.getString("capacity");
				String cost = resultset.getString("cost");
				String under48InchesAllowed = resultset.getString("under48InchesAllowed");
				String minimumAge = resultset.getString("minimumAge");
				String averageLineUp = resultset.getString("averageLineUp");
				
				//Determine operation status
				if(inOperation.equals("1")) {
					inOperation="Yes";
				} else {
					inOperation="No";
				}
				
				//Determine if under 48 inches is allowed
				if(under48InchesAllowed.equals("1")) {
					under48InchesAllowed="Yes";
				} else {
					under48InchesAllowed="No";
				}
				
				String nextItem =String.format("<b>%s</b><br>In Operation: %s<br>Capacity: %s<br>Cost: $%s<br>Under 48 Inches Allowed: %s<br>Minimum Age: %s<br>Average Lineup: %s<br><br>", attractionName, inOperation, capacity, cost, under48InchesAllowed, minimumAge, averageLineUp);
				list += nextItem;
			}
			closeDB();
			return list;
		} catch (Exception e) {
			return "";
		}
	}
	
	public String getAttractionsByMinHeight() {
		try {
			openDB();
			String qstr = String.format("SELECT attractionName, inOperation, capacity, cost, under48InchesAllowed, minimumAge, averageLineUp FROM Attractions WHERE under48InchesAllowed=1");
			Statement statement = conn.createStatement();
			ResultSet resultset = statement.executeQuery(qstr);
	
			String list = "";
			while(resultset.next()){
				String attractionName = resultset.getString("attractionName");
				String inOperation = resultset.getString("inOperation");
				String capacity = resultset.getString("capacity");
				String cost = resultset.getString("cost");
				String under48InchesAllowed = resultset.getString("under48InchesAllowed");
				String minimumAge = resultset.getString("minimumAge");
				String averageLineUp = resultset.getString("averageLineUp");
				
				//Determine operation status
				if(inOperation.equals("1")) {
					inOperation="Yes";
				} else {
					inOperation="No";
				}
				
				//Determine if under 48 inches is allowed
				if(under48InchesAllowed.equals("1")) {
					under48InchesAllowed="Yes";
				} else {
					under48InchesAllowed="No";
				}
				
				String nextItem =String.format("<b>%s</b><br>In Operation: %s<br>Capacity: %s<br>Cost: $%s<br>Under 48 Inches Allowed: %s<br>Minimum Age: %s<br>Average Lineup: %s<br><br>", attractionName, inOperation, capacity, cost, under48InchesAllowed, minimumAge, averageLineUp);
				list += nextItem;
			}
			closeDB();
			return list;
		} catch (Exception e) {
			return "";
		}
	}
	
	public String getOpenAttractions() {
		try {
			openDB();
			String qstr = String.format("SELECT attractionName, inOperation, capacity, cost, under48InchesAllowed, minimumAge, averageLineUp FROM Attractions WHERE inOperation=1");
			Statement statement = conn.createStatement();
			ResultSet resultset = statement.executeQuery(qstr);
	
			String list = "";
			while(resultset.next()){
				String attractionName = resultset.getString("attractionName");
				String inOperation = resultset.getString("inOperation");
				String capacity = resultset.getString("capacity");
				String cost = resultset.getString("cost");
				String under48InchesAllowed = resultset.getString("under48InchesAllowed");
				String minimumAge = resultset.getString("minimumAge");
				String averageLineUp = resultset.getString("averageLineUp");
				
				//Determine operation status
				if(inOperation.equals("1")) {
					inOperation="Yes";
				} else {
					inOperation="No";
				}
				
				//Determine if under 48 inches is allowed
				if(under48InchesAllowed.equals("1")) {
					under48InchesAllowed="Yes";
				} else {
					under48InchesAllowed="No";
				}
				
				String nextItem =String.format("<b>%s</b><br>In Operation: %s<br>Capacity: %s<br>Cost: $%s<br>Under 48 Inches Allowed: %s<br>Minimum Age: %s<br>Average Lineup: %s<br><br>", attractionName, inOperation, capacity, cost, under48InchesAllowed, minimumAge, averageLineUp);
				list += nextItem;
			}
			closeDB();
			return list;
		} catch (Exception e) {
			return "";
		}
	}

	public boolean validateUser(String userName, String password) {
		try {
			openDB();
			String qstr = String.format("SELECT staffPeopleID FROM StaffPeople WHERE userName='%s' AND password='%s'",userName, password);
			Statement statement = conn.createStatement();
			ResultSet resultset = statement.executeQuery(qstr);
			
			
			if(resultset.next()) {
				closeDB();
				return true;
			}
			
			closeDB();
			return false;
		} catch (Exception e) {
			return false;
		}
	}
	
	public String getStaffID(String userName) {
		try {
			openDB();
			String qstr = String.format("SELECT staffPeopleID FROM StaffPeople WHERE userName='%s'",userName);
			Statement statement = conn.createStatement();
			ResultSet resultset = statement.executeQuery(qstr);
			
			resultset.next();
			String staffID = resultset.getString("staffPeopleID");
			closeDB();
			return staffID;
		} catch (Exception e) {
			return "";
		}
	}
	
	public String getUserType(String userName) {
		try {
			openDB();
			String qstr = String.format("SELECT userType FROM StaffPeople WHERE userName='%s'",userName);
			Statement statement = conn.createStatement();
			ResultSet resultset = statement.executeQuery(qstr);
			
			resultset.next();
			String userType = resultset.getString("userType");
			closeDB();
			return userType;
		} catch (Exception e) {
			return "";
		}
	}

	public String getAttractions() {
		try {
			openDB();
			String qstr = String.format("SELECT attractionID, attractionName FROM Attractions");
			Statement statement = conn.createStatement();
			ResultSet resultset = statement.executeQuery(qstr);
	
			String list = "<select name='attractionID'>";
			while(resultset.next()){
				int attractionID = resultset.getInt("attractionID");
				String attractionName = resultset.getString("attractionName");
	
				String nextItem =String.format("<option value='%d'>%s</option>\n", attractionID, attractionName);
				list += nextItem;
			}
			
			list += "</select>";
			closeDB();
			return list;
		} catch (Exception e) {
			return "";
		}
	}
	
	public String getStaffMembers() {
		try {
			openDB();
			String qstr = String.format("SELECT sp.staffPeopleID, p.firstName, p.lastName, sd.departmentName FROM StaffPeople sp " +
					"INNER JOIN People p " +
					"ON p.peopleID=sp.peopleID " +
					"INNER JOIN StaffDepartments sd " +
					"ON sd.staffDepartmentID=sp.staffDepartmentID");
			Statement statement = conn.createStatement();
			ResultSet resultset = statement.executeQuery(qstr);
	
			String list = "<select name='staffID'>";
			while(resultset.next()){
				String staffPeopleID = resultset.getString("staffPeopleID");
				String lastName = resultset.getString("lastName");
				String firstName = resultset.getString("firstName");
				String departmentName = resultset.getString("departmentName");
	
				String nextItem =String.format("<option value='%s'>%s, %s: %s</option>\n", staffPeopleID, lastName, firstName, departmentName);
				list += nextItem;
			}
			
			list += "</select>";
			closeDB();
			return list;
		} catch (Exception e) {
			System.out.println(e.toString());
			return "";
		}
	}
	
	public String getRollerCoasters() {
		try {
			openDB();
			String qstr = String.format("SELECT a.attractionName, a.inOperation, a.capacity, a.cost, " +
					"a.under48InchesAllowed, a.minimumAge, a.averageLineUp, rc.scariness FROM RollerCoasters rc " +
					"INNER JOIN Attractions a ON a.attractionID=rc.attractionID " +
					"ORDER BY rc.scariness DESC");
			Statement statement = conn.createStatement();
			ResultSet resultset = statement.executeQuery(qstr);
	
			String list = "";
			while(resultset.next()){
				String attractionName = resultset.getString("attractionName");
				String inOperation = resultset.getString("inOperation");
				String capacity = resultset.getString("capacity");
				String cost = resultset.getString("cost");
				String under48InchesAllowed = resultset.getString("under48InchesAllowed");
				String minimumAge = resultset.getString("minimumAge");
				String averageLineUp = resultset.getString("averageLineUp");
				String scariness = resultset.getString("scariness");
				
				//Determine operation status
				if(inOperation.equals("1")) {
					inOperation="Yes";
				} else {
					inOperation="No";
				}
				
				//Determine if under 48 inches is allowed
				if(under48InchesAllowed.equals("1")) {
					under48InchesAllowed="Yes";
				} else {
					under48InchesAllowed="No";
				}
				
				String nextItem =String.format("<b>%s</b><br>Scariness: %s<br>In Operation: %s<br>Capacity: %s<br>Cost: $%s<br>Under 48 Inches Allowed: %s<br>Minimum Age: %s<br>Average Lineup: %s<br><br>", attractionName, scariness, inOperation, capacity, cost, under48InchesAllowed, minimumAge, averageLineUp);
				list += nextItem;
			}
			closeDB();
			return list;
		} catch (Exception e) {
			return "";
		}
	}
	
	public String getAttractionByID(String attractionID) {
		try {
			openDB();
			String qstr = String.format("SELECT attractionName, inOperation, capacity, cost, under48InchesAllowed, minimumAge, averageLineUp FROM Attractions WHERE attractionID=%s", attractionID);
			Statement statement = conn.createStatement();
			ResultSet resultset = statement.executeQuery(qstr);
	
			String list = "";
			while(resultset.next()){
				String attractionName = resultset.getString("attractionName");
				String inOperation = resultset.getString("inOperation");
				String capacity = resultset.getString("capacity");
				String cost = resultset.getString("cost");
				String under48InchesAllowed = resultset.getString("under48InchesAllowed");
				String minimumAge = resultset.getString("minimumAge");
				String averageLineUp = resultset.getString("averageLineUp");
				
				//Determine operation status
				if(inOperation.equals("1")) {
					inOperation="Yes";
				} else {
					inOperation="No";
				}
				
				//Determine if under 48 inches is allowed
				if(under48InchesAllowed.equals("1")) {
					under48InchesAllowed="Yes";
				} else {
					under48InchesAllowed="No";
				}
				
				String nextItem =String.format("<b>%s</b><br>In Operation: %s<br>Capacity: %s<br>Cost: $%s<br>Under 48 Inches Allowed: %s<br>Minimum Age: %s<br>Average Lineup: %s<br><br>", attractionName, inOperation, capacity, cost, under48InchesAllowed, minimumAge, averageLineUp);
				list += nextItem;
			}
			closeDB();
			return list;
		} catch (Exception e) {
			return "";
		}
	}
	
	public String getAttractionNameByID(String attractionID) {
		try {
			openDB();
			String qstr = String.format("SELECT attractionName FROM Attractions WHERE attractionID=%s", attractionID);
			Statement statement = conn.createStatement();
			ResultSet resultset = statement.executeQuery(qstr);

			resultset.next();
			String attractionName = resultset.getString("attractionName");

			closeDB();
			return attractionName;
		} catch (Exception e) {
			return "";
		}
	}
	
	public String getAttractionAllergy(String attractionID, String customerID) {
		try {
			openDB();
			String qstr = String.format("SELECT a.attractionName, an.animalName FROM Customers c " +
					"INNER JOIN People p ON c.peopleID=p.peopleID " +
					"INNER JOIN PeopleAnimalAllergies paa ON paa.peopleID=p.peopleID " +
					"INNER JOIN Animals an ON an.animalID=paa.animalID " +
					"INNER JOIN AnimalAtRides aar ON aar.animalID=an.animalID " +
					"INNER JOIN AnimalRides ar ON ar.animalRideID=aar.animalRideID " +
					"INNER JOIN Attractions a ON a.attractionID=ar.attractionID " +
					"WHERE c.customerID='%s' AND a.attractionID='%s'", customerID, attractionID);
			Statement statement = conn.createStatement();
			ResultSet resultset = statement.executeQuery(qstr);
			
			if(resultset.next()){
				String animalName = resultset.getString("animalName");
				closeDB();
				return "<font color='red'><b>ALERT:</b> Customer Is Allergic To The "+animalName+" At This Attraction!</font>";
			} else {
				closeDB();
				return "";
			}
		} catch (Exception e) {
			System.out.println(e);
			return "";
		}
	}
	
	public void sellTicket(String customerID, String attractionID, String staffID) {
		try {
			openDB();
			Statement statement = conn.createStatement();
			String qstr;
			
			//Get the current date
			Date d = new Date(); 
			SimpleDateFormat formater = new SimpleDateFormat("yy-MM-dd");
		    String currentDate = formater.format(d);
			
			//Create new ticket record
			qstr = String.format("INSERT INTO Tickets (ticketDate, attractionID, customerID, staffPeopleID) " +
					"values('%s','%s','%s','%s');", currentDate, attractionID, customerID, staffID);
			statement.execute(qstr);
			
			closeDB();
		} catch (Exception e) {
			System.out.println(e.toString());
		}
	}
	
	public int getLastTicketID() {
		try {
			openDB();
			Statement statement = conn.createStatement();
			String qstr;
			ResultSet resultset;
			
			//Get the last inserted ticketID
			qstr = "SELECT ticketID FROM Tickets ORDER BY ticketID DESC LIMIT 1";
			resultset = statement.executeQuery(qstr);
			resultset.next();
			int ticketID = resultset.getInt("ticketID");
			
			closeDB();
			
			return ticketID;
		} catch (Exception e) {
			return 0;
		}
	}

	public void toggleAttraction(String attractionID, String status) {
		try {
			openDB();
			Statement statement = conn.createStatement();
			String qstr;
			
			//Get the last inserted ticketID
			qstr = "UPDATE Attractions SET inOperation='"+status+"' WHERE attractionID='"+attractionID+"'";
			statement.execute(qstr);
		} catch (Exception e) {
			System.out.println(e.toString());
		}
	}
	
	public String getAttractionReport(String attractionID, String chosenDate) {
		try {
			openDB();
			Statement statement = conn.createStatement();
			String qstr;
			ResultSet resultset;
			
			//Get the last inserted ticketID
			qstr = "SELECT SUM(a.cost) AS total FROM Tickets t " +
					"JOIN Attractions a " +
					"ON a.attractionID=t.attractionID " +
					"WHERE t.attractionID='"+attractionID+"' AND t.ticketDate='"+chosenDate+"'";
			resultset = statement.executeQuery(qstr);
			resultset.next();
			String total = "$"+resultset.getString("total");
			
			closeDB();
			
			return total;
		} catch (Exception e) {
			System.out.println(e.toString());
			return "";
		}
	}
	
	public String getAllAttractionsReport(String chosenDate) {
		try {
			openDB();
			Statement statement = conn.createStatement();
			String qstr;
			ResultSet resultset;
			
			//Get the last inserted ticketID
			qstr = "SELECT SUM(a.cost) AS total FROM Tickets t " +
				"JOIN Attractions a " +
				"ON a.attractionID=t.attractionID " +
				"WHERE t.ticketDate='"+chosenDate+"'";
			resultset = statement.executeQuery(qstr);
			resultset.next();
			String total = "$"+resultset.getString("total");
			
			closeDB();
			
			return total;
		} catch (Exception e) {
			System.out.println(e.toString());
			return "";
		}
	}
	
	public String getStaffReport(String staffID, String chosenDate) {
		try {
			openDB();
			Statement statement = conn.createStatement();
			String qstr;
			ResultSet resultset;
			
			//Get the last inserted ticketID
			qstr = "SELECT SUM(a.cost) AS total FROM Tickets t " +
				"JOIN StaffPeople sp " +
				"ON sp.staffPeopleID=t.staffPeopleID " +
				"JOIN Attractions a " +
				"ON a.attractionID=t.attractionID " +
				"WHERE t.ticketDate='"+chosenDate+"' AND sp.staffPeopleID='"+staffID+"'";
			resultset = statement.executeQuery(qstr);
			resultset.next();
			String total = "$"+resultset.getString("total");
			
			closeDB();
			
			return total;
		} catch (Exception e) {
			System.out.println(e.toString());
			return "";
		}
	}
	
	public String getStaffNameByID(String staffID) {
		try {
			openDB();
			String qstr = String.format("SELECT p.firstName, p.lastName FROM StaffPeople sp " +
					"JOIN People p " +
					"ON p.peopleID=sp.peopleID " +
					"WHERE sp.staffPeopleID=%s", staffID);
			Statement statement = conn.createStatement();
			ResultSet resultset = statement.executeQuery(qstr);

			resultset.next();
			String firstName = resultset.getString("firstName");
			String lastName = resultset.getString("lastName");

			closeDB();
			return firstName+" "+lastName;
		} catch (Exception e) {
			return "";
		}
	}
}
