package beanPkg;

public class ThemeParkBean {
	private DBConn db;
	
	public ThemeParkBean() {
		db = new DBConn("themeParkDB");
	}
	
	public String getAnimals() {
		return db.getAnimals();
	}
	
	public String addCustomer(String firstName, String lastName, String birthday, String phone, String street, 
			String city, String postalCode, String province, String country, String animalID, String under48) {
		return db.addCustomer(firstName, lastName, birthday, phone, 
				street, city, postalCode, province, country, animalID, under48);
	}
	
	public void addStaffMember(String firstName, String lastName, String birthday, String phone, String street, String city, 
			String postalCode, String province, String country, String userName, String password, String departmentID) {
		db.addStaffMember(firstName, lastName, birthday, phone, 
				street, city, postalCode, province, country, userName, password, departmentID);
	}
	
	public String searchCustomers(String firstName, String lastName, String birthday, String phone, String street, 
			String city, String postalCode, String province, String country, String under48) {
		return db.searchCustomers(firstName, lastName, birthday, phone, 
				street, city, postalCode, province, country, under48);
	}
	
	public String searchStaff(String firstName, String lastName, String department, String birthday, String phone, String street, 
			String city, String postalCode, String province, String country) {
		return db.searchStaff(firstName, lastName, department, birthday, phone, 
				street, city, postalCode, province, country);
	}
	
	public String getDepartments() {
		return db.getDepartments();
	}
	
	public String getAttractionsByAge(String age) {
		return db.getAttractionsByAge(age);
	}
	
	public String getAttractionsByMinHeight() {
		return db.getAttractionsByMinHeight();
	}
	
	public String getOpenAttractions() {
		return db.getOpenAttractions();
	}

	public boolean validateUser(String userName, String password) {
		return db.validateUser(userName, password);
	}
	
	public String getStaffID(String userName) {
		return db.getStaffID(userName);
	}
	
	public String getUserType(String userName) {
		return db.getUserType(userName);
	}

	public String getAttractions() {
		return db.getAttractions();
	}
	
	public String getStaffMembers() {
		return db.getStaffMembers();
	}
	
	public String getRollerCoasters() {
		return db.getRollerCoasters();
	}
	
	public String getAttractionByID(String attractionID) {
		return db.getAttractionByID(attractionID);
	}
	
	public String getAttractionNameByID(String attractionID) {
		return db.getAttractionNameByID(attractionID);
	}
	
	public String getAttractionAllergy(String attractionID, String customerID) {
		return db.getAttractionAllergy(attractionID, customerID);
	}
	
	public void sellTicket(String customerID, String attractionID, String staffID) {
		db.sellTicket(customerID, attractionID, staffID);
	}
	
	public int getLastTicketID() {
		return db.getLastTicketID();
	}

	public void toggleAttraction(String attractionID, String status) {
		db.toggleAttraction(attractionID, status);
	}
	
	public String getAttractionReport(String attractionID, String chosenDate) {
		return db.getAttractionReport(attractionID, chosenDate);
	}
	
	public String getAllAttractionsReport(String chosenDate) {
		return db.getAllAttractionsReport(chosenDate);
	}
	
	public String getStaffReport(String staffID, String chosenDate) {
		return db.getStaffReport(staffID, chosenDate);
	}
	
	public String getStaffNameByID(String staffID) {
		return db.getStaffNameByID(staffID);
	}
}
