package clientPkg;

import java.awt.Color;
import java.awt.Dimension;
import interfacePkg.Constants;
import javax.swing.*;

public class Attempt extends JPanel implements Constants {
	private JLabel numberLabel;
	private int attemptNumber;
	private int numBalls;
	private Ball[] balls;
	private Peg[] pegs;
	
	public Attempt(ColorSelector cs,int s, int a) {
		//Set the constructor parameters to global variables
		ColorSelector colorSelector = cs;
		attemptNumber=a;
		numBalls=s;
		
		//Setup attempt panel
		this.setPreferredSize(new Dimension(190+(numBalls*BALLWIDTH), 35));
		this.setBackground(new Color(RCOLOR, GCOLOR, BCOLOR));
		
		//Create ball panel
		JPanel ballPanel = new JPanel();
		ballPanel.setBackground(new Color(RCOLOR, GCOLOR, BCOLOR));
		ballPanel.setPreferredSize(new Dimension(50+(numBalls*BALLWIDTH), 30));
		
		//Create peg panel
		JPanel pegPanel = new JPanel();
		pegPanel.setBackground(new Color(RCOLOR, GCOLOR, BCOLOR));
		pegPanel.setPreferredSize(new Dimension(3+(numBalls)*(PEGWIDTH+8)/2, 30));
		
		//Create attempt number label
		if(attemptNumber!=-1) {
			numberLabel = new JLabel("<html><h1>"+attemptNumber+"</h1></html>");
		} else {
			numberLabel = new JLabel("<html><h1></h1></html>");
		}
		numberLabel.setPreferredSize(new Dimension(40, 30));
		
		//Add the components to the attemptPanel
		this.add(numberLabel);
		this.add(ballPanel);
		this.add(pegPanel);
		
		balls = new Ball[numBalls];
		pegs = new Peg[numBalls];
		
		//Make Pegs and Balls
		for(int i=0;i<numBalls;i++) {
			Ball b = new Ball(colorSelector, CLEAR);
			balls[i] = b;
			ballPanel.add(b);
			
			if(attemptNumber!=-1) {
				Peg p = new Peg();
				pegs[i] = p;
				pegPanel.add(p);
			}
		}
	}
	
	public void setPegs(int[] result) {
		for(int i=0;i<pegs.length;i++) {
			pegs[i].setState(result[i]);
		}
	}
	
	public void setBalls(int[] b) {
		for(int i=0;i<b.length;i++) {
			balls[i].setState(UNLOCKED);
			balls[i].setColor(b[i]);
			balls[i].setState(LOCKED);
		}
	}
	
	public void unlockBalls() {
		for(int i=0;i<balls.length;i++) {
			balls[i].setState(UNLOCKED);
		}
		numberLabel.setText("<html><h1>&raquo;"+attemptNumber+"</h1></html>");
	}
	
	public void lockBalls() {
		for(int i=0;i<balls.length;i++) {
			balls[i].setState(LOCKED);
		}
		numberLabel.setText("<html><h1>"+attemptNumber+"</h1></html>");
	}
	
	public int[] getBallColors() {
		int colors[] = new int[balls.length];
		
		for(int i=0;i<balls.length;i++) {
			colors[i] = balls[i].getColor();
		}
		
		return colors;
	}
	
	public void clearBalls() {
		for(int i=0;i<balls.length;i++) {
			balls[i].setColor(CLEAR);
		}
	}
}
