package clientPkg;

import javax.swing.*;
import interfacePkg.Constants;
import java.awt.*;
import java.awt.event.*;

public class Ball extends JPanel implements Constants, MouseListener {
	protected ColorSelector colorSelector;
	protected JLabel ballLabel;
	protected int color;
	protected int state;
	
	public Ball(ColorSelector cs, int c) {
		this.setPreferredSize(new Dimension(BALLWIDTH, BALLHEIGHT));
		this.setLayout(new FlowLayout(FlowLayout.CENTER, 0, 0));
		this.setBackground(new Color(RCOLOR, GCOLOR, BCOLOR));

		//Create BallLabel
		ballLabel = new JLabel();
		ballLabel.addMouseListener(this);
		this.add(ballLabel);
		
		colorSelector = cs;
		state = UNLOCKED;
		setColor(c);
		state = LOCKED;
	}
	
	public void setColor(int c) {
		if(state==UNLOCKED) {
			ImageIcon icon;
			
			//Create an icon corrosponding to the int value
			switch (c) {
			    case CLEAR: icon = new ImageIcon(getClass().getResource(CLEARIMAGE)); break;
			    case BLUE: icon = new ImageIcon(getClass().getResource(BLUEIMAGE)); break;
			    case RED: icon = new ImageIcon(getClass().getResource(REDIMAGE)); break;
			    case GREEN: icon = new ImageIcon(getClass().getResource(GREENIMAGE)); break;
			    case BLACK: icon = new ImageIcon(getClass().getResource(BLACKIMAGE)); break;
			    case YELLOW: icon = new ImageIcon(getClass().getResource(YELLOWIMAGE)); break;
			    case ORANGE: icon = new ImageIcon(getClass().getResource(ORANGEIMAGE)); break;
			    case SILVER: icon = new ImageIcon(getClass().getResource(SILVERIMAGE)); break;
			    case WHITE: icon = new ImageIcon(getClass().getResource(WHITEIMAGE)); break;
			    case PURPLE: icon = new ImageIcon(getClass().getResource(PURPLEIMAGE)); break;
			    default: icon = new ImageIcon(getClass().getResource(CLEARIMAGE)); break;
			}
			
			//Set the color of the ball
			color = c;
			
			//Set the icon for the label
			ballLabel.setIcon(icon);
			ballLabel.updateUI();
		}
	}
	
	public void setState(int s) {
		state = s;
	}
	
	public int getColor() {
		return color;
	}
	
	public void mouseClicked(MouseEvent e) {
		//Get the current color
		int currentColor = colorSelector.getColor();
		//Set the color to the current color
		setColor(currentColor);
	}
	public void mousePressed (MouseEvent e) {}
	public void mouseReleased (MouseEvent e) {}
	public void mouseEntered (MouseEvent e) {}
	public void mouseExited (MouseEvent e) {}
}