package clientPkg;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import interfacePkg.*;

import javax.swing.*;

public class BoardMenu<O extends SinglePlayerServantIFC> extends JMenuBar implements Constants {
	public BoardMenu(Board<O> b, final int gameType, final O mo, JFrame bf, String pn) {
		//Save the JFrame to memory
		final JFrame boardFrame = bf;
		final Board<O> board = b;
		final O mmobj = mo;
		final String playerName = pn;
		
		//Create the menus for the MenuBar
	    JMenu fileMenu = new JMenu("File");
	    
	    //Add the menus to the MenuBar
	    this.add(fileMenu);
	    
	    //Create the FileMenu items
	    JMenuItem newItem = new JMenuItem("New");
	    newItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				//Check if this is a multiplayer game
				if(gameType==MULTIPLAYER) {
					final MultiPlayerServantIFC mmobj = (MultiPlayerServantIFC) mo;
					
					//Ask user if they are sure they want to quit
					int value = JOptionPane.showConfirmDialog(
						    boardFrame,
						    "Are you sure you want to quit this game?\n"
						    + "Quiting will dissconect your opponent from the game too!",
						    "Confirm Exit",
						    JOptionPane.YES_NO_OPTION);

					//If use confirms they want to quit
					if (value == JOptionPane.YES_OPTION) {
						//Close the game
						board.closeGame();
						
						try {
							//Send message to the server that you are quiting the game
							mmobj.setExit(playerName);
						} catch (Exception ex) {
							ex.printStackTrace();
						}
						
						//Open the main menu again
						new MainMenu();
						
					}
				} else {
					//Open the main menu again
					new MainMenu();
					board.closeGame();
				}
			}
		});
	    fileMenu.add(newItem);
	    JMenuItem exitItem = new JMenuItem("Exit");
	    exitItem.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				//Check if this is a multiplayer game
				if(gameType==MULTIPLAYER) {
					//Ask user if they are sure they want to quit
					int value = JOptionPane.showConfirmDialog(
						    boardFrame,
						    "Are you sure you want to quit this game?\n"
						    + "Quiting will dissconect your opponent from the game too!",
						    "Confirm Exit",
						    JOptionPane.YES_NO_OPTION);

					//If use confirms they want to quit
					if (value == JOptionPane.YES_OPTION) {
						final MultiPlayerServantIFC mmobj = (MultiPlayerServantIFC) mo;
						
						//Close the game
						board.closeGame();
						
						try {
							//Send message to the server that you are quiting the game
							mmobj.setExit(playerName);
						} catch (Exception ex) {
							ex.printStackTrace();
						}
						
						//Open the main menu again
						new MainMenu();
						
						System.exit(0);
					}
				} else {
					System.exit(0);
				}
			}
		});
	    fileMenu.add(exitItem);
	}
}
