package clientPkg;

import interfacePkg.Constants;
import interfacePkg.MultiPlayerServantIFC;
import interfacePkg.SinglePlayerServantIFC;
import javax.swing.*;

import java.awt.*;
import java.awt.event.*;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ChatBox<O> extends JFrame implements Constants, MouseListener, MouseMotionListener, KeyListener {
	private Point location;
	private MouseEvent pressed;
	private static int TEXTAREAHEIGHT=75;
	private static int TEXTFIELDHEIGHT=25;
	private static int CHATHEIGHT=125;
	private String playerName;
	private JTextArea messageHistory;
	private O mmobj;
	final JTextField messageInput = new JTextField();
	
	public ChatBox(O mo, int boardWidth, int boardHeight, String pn) {
		playerName = pn;
		mmobj = mo;
		
		//Add mouse listeners
		this.addMouseListener(this);
		this.addMouseMotionListener(this);
		
		//Set the size of the frame
		this.setPreferredSize(new Dimension(boardWidth, CHATHEIGHT));
		
		//Set the location of the frame
		this.setLocation(BOARDSTARTX,BOARDSTARTY+boardHeight);
		
		//Create the chatPanel
		JPanel chatPanel = new JPanel();
		chatPanel.setBackground(new Color(RCOLOR, GCOLOR, BCOLOR));
		this.getContentPane().add(chatPanel);
		
		//Create the JTextArea
		messageHistory = new JTextArea();
		messageHistory.setDisabledTextColor(Color.BLACK);
		messageHistory.setEnabled(false);
		//messageHistory.setPreferredSize(new Dimension(boardWidth-20, TEXTAREAHEIGHT));
		
		//Create a scrollpane to make the text area scrollable
		JScrollPane scrollPane = new JScrollPane(messageHistory);
		scrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		scrollPane.setPreferredSize(new Dimension(boardWidth-20, TEXTAREAHEIGHT));
		//Add scroll pane to eventFrame
		chatPanel.add(scrollPane);
		
		//Create the JTextField
		messageInput.addKeyListener(this);
		messageInput.setPreferredSize(new Dimension(boardWidth-88, TEXTFIELDHEIGHT));
		chatPanel.add(messageInput);
		
		final MultiPlayerServantIFC multimmobj = (MultiPlayerServantIFC) mmobj;
		
		//Send button
		JButton sendButton = new JButton("Send");
		sendButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				try {
					if(!messageInput.getText().equals("")) {
						multimmobj.sendMessage(messageInput.getText(), playerName);
						messageInput.setText("");
					}
				} catch (Exception ex) {
					ex.printStackTrace();
				}
			}
		});
		chatPanel.add(sendButton);

		//Start the chat thread
		ChatThread ct = new ChatThread(this, multimmobj);
		ct.start();
		
		//Borderless window
    	this.setUndecorated(true);
    	
		//Resize the window
    	this.pack();
		
		//Display the window
    	this.setVisible(true);
	}
	
	public void close() {
		this.setVisible (false);
		this.dispose();
	}

	//Chat Thread Class -Used to run an infinate loop checking for new messages
	class ChatThread extends Thread {
		MultiPlayerServantIFC mmobj;
		private JFrame boardFrame;
		private boolean loop;
		
		public ChatThread(JFrame cf, MultiPlayerServantIFC mo) {
			mmobj = mo;
			boardFrame = cf;
			loop = true;
		}
		
		public void closeThread() {
			loop = false;
		}

		public void run() {
			while(loop) {
	    		try {
	    			//Get any new messages
	    			String message = mmobj.receiveMessage(playerName);
	    			
	    			//Check for null response
	    			if(message!=null) {
	    				writeLine(message);
	    			}

	    			Thread.sleep(100);
	    		} catch(Exception e) {
	    			e.printStackTrace();
	    		}
			}
			closeThread();
		}
	}
	
	public void writeLine(String s) {
		//Check if this is the first line
		if(messageHistory.getDocument().getLength()==0) {
			messageHistory.append(s);
		} else {
			//get the text from the textArea and add the text to be inserted
			String text = messageHistory.getText();
			messageHistory.setText("");
			
			messageHistory.append(text + "\n" + s);
		}
		
		//Autoscroll the scrollPane to the bottom
		messageHistory.setCaretPosition(messageHistory.getDocument().getLength());
	}
	
    public void keyTyped(KeyEvent e) {}
 
    public void keyPressed(KeyEvent e) {
    	if(e.getKeyCode() == KeyEvent.VK_ENTER) {
    		if(!messageInput.getText().equals("")) {
		    	final MultiPlayerServantIFC multimmobj = (MultiPlayerServantIFC) mmobj;
		    	try {
			    	multimmobj.sendMessage(messageInput.getText(), playerName);
			    	messageInput.setText("");
		    	} catch (Exception ex) {
		    		ex.printStackTrace();
		    	}
    		}
    	}
    }
 
    public void keyReleased(KeyEvent e) {}
 
	public void mouseClicked(MouseEvent e) {}
	public void mouseReleased(MouseEvent e) {}
	
	public void mousePressed(MouseEvent me) {
		pressed = me;
	}
	
	public void mouseDragged(MouseEvent me) {
		location = this.getLocation(location);
		int x = location.x - pressed.getX() + me.getX();
		int y = location.y - pressed.getY() + me.getY();
		this.setLocation(x, y);
	}
 
	public void mouseMoved(MouseEvent e) {}
	public void mouseEntered(MouseEvent e) {}
	public void mouseExited(MouseEvent e) {}
}
