package clientPkg;

import interfacePkg.*;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class MainMenu implements Constants, MouseListener, MouseMotionListener {
	private final JFrame menuFrame;
	private Point location;
	private MouseEvent pressed;
	
	public MainMenu() {
    	//Setup the top level frame (window)
		//JFrame.setDefaultLookAndFeelDecorated(true);
		menuFrame = new JFrame("Mastermind");
		
		//Add mouse listeners
		menuFrame.addMouseListener(this);
		menuFrame.addMouseMotionListener(this);
		
		//Set the default close operation
		menuFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		
		//Set the size of the frame
		menuFrame.setPreferredSize(new Dimension(MENUWIDTH,MENUHEIGHT));
		
		//Set the location of the frame
		menuFrame.setLocation(MENUSTARTX,MENUSTARTY);
		
		//Disable resizing of frame
    	menuFrame.setResizable(false);
    	
    	//Create the menu panel
    	JPanel menuPanel = new JPanel();
    	menuPanel.setBackground(Color.BLACK);
    	menuFrame.getContentPane().add(menuPanel);
    	
    	//Create label for image
    	JLabel logoPanel = new JLabel();
    	logoPanel.setIcon(new ImageIcon(getClass().getResource(MENULOGO)));
    	menuPanel.add(logoPanel);
    	
		//Single Player Button
		JButton singleButton = new JButton("Single Player");
		singleButton.setPreferredSize(new Dimension(MENUBUTTONWIDTH,MENUBUTTONHEIGHT));
		singleButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				new Setup(SINGLEPLAYER);
				menuFrame.setVisible (false);
				menuFrame.dispose ();
			}
		});
		menuPanel.add(singleButton);
		
		//Multiplayer Player Button
		JButton multiVersesButton = new JButton("Multiplayer");
		multiVersesButton.setPreferredSize(new Dimension(MENUBUTTONWIDTH,MENUBUTTONHEIGHT));
		multiVersesButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				new Setup(MULTIPLAYER);
				menuFrame.setVisible (false);
				menuFrame.dispose ();
			}
		});
		menuPanel.add(multiVersesButton);
		
		//Exit Button
		JButton exitButton = new JButton("Exit");
		exitButton.setPreferredSize(new Dimension(MENUBUTTONWIDTH,MENUBUTTONHEIGHT));
		exitButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				System.exit(0);
			}
		});
		menuPanel.add(exitButton);
		
		//Borderless window
		menuFrame.setUndecorated(true);
		
		menuFrame.setUndecorated(true); 
		//Resize the window
		menuFrame.pack();
		
		//Display the window
		menuFrame.setVisible(true);
    }
	
	public void mousePressed(MouseEvent me) {
		pressed = me;
	}
	
	
 
	public void mouseClicked(MouseEvent e) {}
	public void mouseReleased(MouseEvent e) {}
 
	public void mouseDragged(MouseEvent me) {
		location = menuFrame.getLocation(location);
		int x = location.x - pressed.getX() + me.getX();
		int y = location.y - pressed.getY() + me.getY();
		menuFrame.setLocation(x, y);
	 }
 
	public void mouseMoved(MouseEvent e) {}
	public void mouseEntered(MouseEvent e) {}
	public void mouseExited(MouseEvent e) {}
}
