package clientPkg;

import interfacePkg.Constants;
import javax.swing.*;

import java.awt.*;

public class Peg extends JLabel implements Constants {
	public Peg() {
		this.setPreferredSize(new Dimension(PEGWIDTH, PEGHEIGHT));
		setState(MISS);
	}
	
	public void setState(int s) {
		ImageIcon icon;
		
		//Create an icon corrosponding to the int value
		switch (s) {
		    case MISS: icon = new ImageIcon(getClass().getResource(MISSIMAGE)); break;
		    case HIT: icon = new ImageIcon(getClass().getResource(HITIMAGE)); break;
		    case CLOSE: icon = new ImageIcon(getClass().getResource(CLOSEIMAGE)); break;
		    default: icon = new ImageIcon(getClass().getResource(MISSIMAGE)); break;
		}
		
		//Set the icon for the label
		this.setIcon(icon);
		this.updateUI();
	}
}
