package clientPkg;

import java.awt.*;

import interfacePkg.Constants;
import javax.swing.*;

public class SelectPanel extends JPanel implements Constants {
	public SelectPanel(ColorSelector cs, int c) {
		int numColors = c;
		
		this.setLayout(new GridBagLayout());
		GridBagConstraints constraints = new GridBagConstraints();
		
		//Setup InputPanel panel
		this.setPreferredSize(new Dimension(225, 100));
		
		//Create ball panel
		JPanel ballSelectPanel = new JPanel();
		constraints.gridwidth = 2;
		constraints.gridx = 0;
		constraints.gridy = 0;
		ballSelectPanel.setPreferredSize(new Dimension(100, 100));
		ballSelectPanel.setBackground(new Color(RCOLOR, GCOLOR, BCOLOR));
		this.add(ballSelectPanel, constraints);
		
		//Make the BallSelects
		for(int i=1;i<=numColors;i++) {
			BallSelect bs = new BallSelect(cs, i);
			ballSelectPanel.add(bs);
		}
	}
}
