package clientPkg;

import java.awt.*;
import java.awt.event.*;
import java.rmi.*;
import java.rmi.registry.*;
import interfacePkg.*;
import javax.swing.*;

public class Setup implements Constants, MouseListener, MouseMotionListener {
	private final JFrame setupFrame;
	private Point location;
	private MouseEvent pressed;
	private static int LABELWIDTH = 100;
	private static int LABELHEIGHT = 15;
	private static int COMBOBOXWIDTH = 70;
	private static int COMBOBOXHEIGHT = 25;
	
	public Setup(final int gameType) {
		//Setup the top level frame (window)
		//JFrame.setDefaultLookAndFeelDecorated(true);
		setupFrame = new JFrame("Mastermind - Setup");
		
		//Add mouse listeners
		setupFrame.addMouseListener(this);
		setupFrame.addMouseMotionListener(this);
		
		//Set the default close operation
		setupFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		
		//Set the size of the frame
		setupFrame.setPreferredSize(new Dimension(SETTINGSWIDTH,SETTINGSHEIGHT));
		
		//Set the location of the frame
		setupFrame.setLocation(SETTINGSSTARTX,SETTINGSSTARTY);
		
		//Disable resizing of frame
		setupFrame.setResizable(false);
    	
		//Create the SetupPanel
		JPanel setupPanel = new JPanel();
		setupPanel.setBackground(new Color(RCOLOR, GCOLOR, BCOLOR));
		setupPanel.setPreferredSize(new Dimension(SETTINGSWIDTH,SETTINGSHEIGHT));
		setupPanel.setLayout(new GridBagLayout());
		setupFrame.getContentPane().add(setupPanel);
		
		//Setup the gridbag constraints
		GridBagConstraints constraints = new GridBagConstraints();
		constraints.insets = new Insets(5,0,0,5);
		
		//Create the game name field outside of if becuase of scope problem
		final JTextField newGameNameTextField = new JTextField(10);
		final JTextField newUsernameTextField = new JTextField(10);
		final JTextField newServerIPTextField = new JTextField(10);
		
		//If this is for multiplayer display multiplayer settings
		if(gameType==MULTIPLAYER) {
			//Join Game label
			JLabel joinGameLabel = new JLabel("<html><h2>Join Game</h2></html>");
			constraints.gridx = 0;
			constraints.gridy = 0;
			constraints.gridwidth = 2;
			setupPanel.add(joinGameLabel, constraints);
			constraints.gridwidth = 1; //Reset gridwidth
			
			//Modify the size of the frame to hold the additional settings
			setupFrame.setPreferredSize(new Dimension(SETTINGSWIDTH,SETTINGSHEIGHT+225));
			
			//Server ip label
			JLabel serverIPLabel = new JLabel("Server IP: ");
			serverIPLabel.setPreferredSize(new Dimension(LABELWIDTH,LABELHEIGHT));
			constraints.gridx = 0;
			constraints.gridy = constraints.gridy+1;
			setupPanel.add(serverIPLabel, constraints);
			
			//Game Name textfield
			final JTextField serverIPTextField = new JTextField(10);
			constraints.gridx = 1;
			setupPanel.add(serverIPTextField, constraints);
			
			//Game name label
			JLabel gameNameLabel = new JLabel("Game Name: ");
			gameNameLabel.setPreferredSize(new Dimension(LABELWIDTH,LABELHEIGHT));
			constraints.gridx = 0;
			constraints.gridy = constraints.gridy+1;
			setupPanel.add(gameNameLabel, constraints);
			
			//Game Name textfield
			final JTextField gameNameTextField = new JTextField(10);
			constraints.gridx = 1;
			setupPanel.add(gameNameTextField, constraints);
			
			//Username label
			JLabel usernameLabel = new JLabel("Username: ");
			usernameLabel.setPreferredSize(new Dimension(LABELWIDTH,LABELHEIGHT));
			constraints.gridx = 0;
			constraints.gridy = constraints.gridy+1;
			setupPanel.add(usernameLabel, constraints);
			
			//Username textfield
			final JTextField usernameTextField = new JTextField(10);
			constraints.gridx = 1;
			setupPanel.add(usernameTextField, constraints);
			
			//The Join Button
			JButton joinButton = new JButton("Join");
			joinButton.setPreferredSize(new Dimension(100,30));
			joinButton.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					try {
						String serverIP = serverIPTextField.getText();
						String gameName = gameNameTextField.getText();
						String playerName = usernameTextField.getText();
						
						if(serverIP.equals("")) {
							serverIP = "localhost";
						}
						
						//Create get the registry from the server
						Registry reg = getRegistry(serverIP);
						
						//Create multiplayer remote object
						MultiPlayerFactoryIFC factory = (MultiPlayerFactoryIFC) reg
								.lookup("//" + serverIP + "/MultiPlayerFactory");
						
						//Check if a game with given name exists and get the game if it does
						MultiPlayerServantIFC mmobj = factory.joinGame(gameName);
						
						//Ensure that a game name was entered in
						if(gameType==MULTIPLAYER && gameName.equals("")) {
							//Check min and max for numColors
							JOptionPane.showMessageDialog(setupFrame, "You must enter a game name!", "AHH!", JOptionPane.ERROR_MESSAGE);
						} else if(usernameTextField.getText().equals("")) {
							//Check min and max for numColors
							JOptionPane.showMessageDialog(setupFrame, "You must enter a username!", "AHH!", JOptionPane.ERROR_MESSAGE);						
						} else if(!mmobj.setPlayerName(playerName)) {
							//Check playerName is not chosen
							JOptionPane.showMessageDialog(setupFrame, "Username taken already!", "AHH!", JOptionPane.ERROR_MESSAGE);
						} else if(usernameTextField.getText().length()>10) {
							//Check playerName is not chosen
							JOptionPane.showMessageDialog(setupFrame, "Username can only be maximum 10 characters!", "AHH!", JOptionPane.ERROR_MESSAGE);
						} else {
							//Check if the mmobj is null meaning there was no game found
							if(mmobj==null) {
								//Display message saying game does not exist
								JOptionPane.showMessageDialog(setupFrame, "Game name \""+gameName+"\" does not exist!", "AHH!", JOptionPane.ERROR_MESSAGE);
							} else {
								//Get the settings of the game joined ie. attempts, balls, colors
								int numAttempts = mmobj.getNumAttempts();
								int numBalls = mmobj.getNumBalls();
								int numColors = mmobj.getNumColors();
								
								//Give the signal to start the game
								mmobj.startGame();
								
								//Create the multiplayer player board
								Board<MultiPlayerServantIFC> b = new Board<MultiPlayerServantIFC>(MULTIPLAYER, numAttempts, numBalls, numColors, mmobj, playerName);
								
								setupFrame.setVisible (false);
				            	setupFrame.dispose();
							}
						
						}
					} catch (Exception ex) {
						//ex.printStackTrace();
						JOptionPane.showMessageDialog(setupFrame, "Error creating game!\n-Ensure you entered the correct server IP\n-Check your network connection.\n-Server may be down.", "AHH!", JOptionPane.ERROR_MESSAGE);
					}
				}
			});
			constraints.gridx = 0;
			constraints.gridy = constraints.gridy+1;
			constraints.gridwidth = 2;
			setupPanel.add(joinButton, constraints);
			constraints.gridwidth = 1; //Reset gridwidth
			
			//Create Game label
			JLabel createGameLabel = new JLabel("<html><h2>Create Game</h2></html>");
			constraints.gridx = 0;
			constraints.gridy = constraints.gridy+1;
			constraints.gridwidth = 2;
			setupPanel.add(createGameLabel, constraints);
			constraints.gridwidth = 1; //Reset gridwidth
			
			//Server ip label
			JLabel newServerIPLabel = new JLabel("Server IP: ");
			newServerIPLabel.setPreferredSize(new Dimension(LABELWIDTH,LABELHEIGHT));
			constraints.gridx = 0;
			constraints.gridy = constraints.gridy+1;
			setupPanel.add(newServerIPLabel, constraints);
			
			//Game Name textfield
			constraints.gridx = 1;
			setupPanel.add(newServerIPTextField, constraints);
			
			//New game name label
			JLabel newGameNameLabel = new JLabel("Game Name: ");
			newGameNameLabel.setPreferredSize(new Dimension(LABELWIDTH,LABELHEIGHT));
			constraints.gridx = 0;
			constraints.gridy = constraints.gridy+1;
			setupPanel.add(newGameNameLabel, constraints);
			
			//Game Name textfield
			constraints.gridx = 1;
			setupPanel.add(newGameNameTextField, constraints);
			
			//Username label
			JLabel newUsernameLabel = new JLabel("Username: ");
			newUsernameLabel.setPreferredSize(new Dimension(LABELWIDTH,LABELHEIGHT));
			constraints.gridx = 0;
			constraints.gridy = constraints.gridy+1;
			setupPanel.add(newUsernameLabel, constraints);
			
			//Username textfield
			constraints.gridx = 1;
			setupPanel.add(newUsernameTextField, constraints);
		} else {
			//Setup label
			JLabel settingsLabel = new JLabel("<html><h2>Setup</h2></html>");
			constraints.gridx = 0;
			constraints.gridy = 0;
			constraints.gridwidth = 2;
			setupPanel.add(settingsLabel, constraints);
			constraints.gridwidth = 1; //Reset gridwidth
			
			//Server ip label
			JLabel newServerIPLabel = new JLabel("Server IP: ");
			newServerIPLabel.setPreferredSize(new Dimension(LABELWIDTH,LABELHEIGHT));
			constraints.gridx = 0;
			constraints.gridy = constraints.gridy+1;
			setupPanel.add(newServerIPLabel, constraints);
			
			//Game Name textfield
			constraints.gridx = 1;
			setupPanel.add(newServerIPTextField, constraints);
		}
		
		//Difficulty label
		JLabel difficultyLabel = new JLabel("Difficulty: ");
		difficultyLabel.setPreferredSize(new Dimension(LABELWIDTH,LABELHEIGHT));
		constraints.gridx = 0;
		constraints.gridy = constraints.gridy+1;
		setupPanel.add(difficultyLabel, constraints);
		
		//Number of attempts ComboBox
		final JComboBox difficultyComboBox = new JComboBox();
		difficultyComboBox.addItem("Easy");
		difficultyComboBox.addItem("Normal");
		difficultyComboBox.addItem("Hard");
		difficultyComboBox.addItem("Custom");
		difficultyComboBox.setSelectedItem("Normal");
		constraints.gridx = 1;
		difficultyComboBox.setPreferredSize(new Dimension(COMBOBOXWIDTH,COMBOBOXHEIGHT));
		setupPanel.add(difficultyComboBox, constraints);
		
		//Add common settings to the panel
		//Number of attempts label
		JLabel attemptsLabel = new JLabel("Attempts: ");
		attemptsLabel.setPreferredSize(new Dimension(LABELWIDTH,LABELHEIGHT));
		constraints.gridx = 0;
		constraints.gridy = constraints.gridy+1;
		setupPanel.add(attemptsLabel, constraints);
		
		//Number of attempts ComboBox
		final JComboBox numAttemptsComboBox = new JComboBox();
		for(int i=MINATTEMPTS;i<=MAXATTEMPTS;i++) {
			numAttemptsComboBox.addItem(i);
		}
		constraints.gridx = 1;
		numAttemptsComboBox.setPreferredSize(new Dimension(COMBOBOXWIDTH,COMBOBOXHEIGHT));
		setupPanel.add(numAttemptsComboBox, constraints);
		
		//Number of balls label
		JLabel ballsLabel = new JLabel("Balls: ");
		ballsLabel.setPreferredSize(new Dimension(LABELWIDTH,LABELHEIGHT));
		constraints.gridx = 0;
		constraints.gridy = constraints.gridy+1;
		setupPanel.add(ballsLabel, constraints);
		
		//Number of balls ComboBox
		final JComboBox numBallsComboBox = new JComboBox();
		for(int i=MINBALLS;i<=MAXBALLS;i++) {
			numBallsComboBox.addItem(i);
		}
		constraints.gridx = 1;
		numBallsComboBox.setPreferredSize(new Dimension(COMBOBOXWIDTH,COMBOBOXHEIGHT));
		setupPanel.add(numBallsComboBox, constraints);
		
		//Number of colors label
		JLabel colorsLabel = new JLabel("Colors: ");
		colorsLabel.setPreferredSize(new Dimension(LABELWIDTH,LABELHEIGHT));
		constraints.gridx = 0;
		constraints.gridy = constraints.gridy+1;
		setupPanel.add(colorsLabel, constraints);
		
		//Number of colors ComboBox
		final JComboBox numColorsComboBox = new JComboBox();
		for(int i=MINCOLORS;i<=MAXCOLORS;i++) {
			numColorsComboBox.addItem(i);
		}
		constraints.gridx = 1;
		numColorsComboBox.setPreferredSize(new Dimension(COMBOBOXWIDTH,COMBOBOXHEIGHT));
		setupPanel.add(numColorsComboBox, constraints);
		
		//Set the three comboboxes
		numAttemptsComboBox.setSelectedItem(NORMALATTEMPTS);
		numBallsComboBox.setSelectedItem(NORMALBALLS);
		numColorsComboBox.setSelectedItem(NORMALCOLORS);
		
		//Lock all comboboxes
    	numAttemptsComboBox.setEnabled(false);
    	numBallsComboBox.setEnabled(false);
    	numColorsComboBox.setEnabled(false);
		
		//The Create Button
		JButton createButton = new JButton("Create");
		createButton.setPreferredSize(new Dimension(100,30));
		createButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				//Get setting's values
				int numAttempts = Integer.parseInt(numAttemptsComboBox.getSelectedItem().toString());
				int numBalls = Integer.parseInt(numBallsComboBox.getSelectedItem().toString());
				int numColors = Integer.parseInt(numColorsComboBox.getSelectedItem().toString());

				if(numAttempts==0 || numBalls==0 || numColors==0) {
					JOptionPane.showMessageDialog(setupFrame, "Please enter numbers!", "AHH!", JOptionPane.ERROR_MESSAGE);
				} else if(numAttempts>MAXATTEMPTS || numAttempts<MINATTEMPTS){
					//Check min and max for numAttempts
					JOptionPane.showMessageDialog(setupFrame, "Number of attempts must be "+MINATTEMPTS+"-"+MAXATTEMPTS+"!", "AHH!", JOptionPane.ERROR_MESSAGE);
				} else if(numBalls>MAXBALLS || numBalls<MINBALLS) {
					//Check min and max for numBalls
					JOptionPane.showMessageDialog(setupFrame, "Number of balls must be "+MINBALLS+"-"+MAXBALLS+"!", "AHH!", JOptionPane.ERROR_MESSAGE);
				} else if(numColors>MAXCOLORS || numColors<MINCOLORS) {
					//Check min and max for numColors
					JOptionPane.showMessageDialog(setupFrame, "Number of colors must be "+MINCOLORS+"-"+MAXCOLORS+"!", "AHH!", JOptionPane.ERROR_MESSAGE);
				} else if(gameType==MULTIPLAYER && newGameNameTextField.getText().equals("")) {
					//Check min and max for numColors
					JOptionPane.showMessageDialog(setupFrame, "You must enter a game name!", "AHH!", JOptionPane.ERROR_MESSAGE);
				}  else if(gameType==MULTIPLAYER && newUsernameTextField.getText().equals("")) {
					//Check min and max for numColors
					JOptionPane.showMessageDialog(setupFrame, "You must enter a username!", "AHH!", JOptionPane.ERROR_MESSAGE);
				}  else if(newUsernameTextField.getText().length()>10) {
					//Check playerName is not chosen
					JOptionPane.showMessageDialog(setupFrame, "Username can only be maximum 10 characters!", "AHH!", JOptionPane.ERROR_MESSAGE);
				} else {
					try {
						//Get the game name entered
						String gameName = newGameNameTextField.getText();
						String serverIP = newServerIPTextField.getText();
						
						if(serverIP.equals("")) {
							serverIP = "localhost";
						}
						
						//Create get the registry from the server
						Registry reg = getRegistry(serverIP);
						
						//If this is for multiplayer create new multiplayer mastermind
						if(gameType==MULTIPLAYER) {
							//Create multiplayer remote object
							MultiPlayerFactoryIFC factory = (MultiPlayerFactoryIFC) reg
									.lookup("//" + serverIP + "/MultiPlayerFactory");
							MultiPlayerServantIFC mmobj = factory.createGame(gameName);
							
							
							//Check if the mmobj is null mean there was no game found
							if(mmobj==null) {
								//Display message saying game does not exist
								JOptionPane.showMessageDialog(setupFrame, "Game name \""+gameName+"\" already exists!", "AHH!", JOptionPane.ERROR_MESSAGE);
							} else {
								//Setup the game on the server
								mmobj.newGame(numAttempts, numBalls, numColors);
								
								//Set the playerName
								mmobj.setPlayerName(newUsernameTextField.getText());
								
								//Go to waiting screen
								new Waiting(numAttempts, numBalls, numColors, mmobj, newUsernameTextField.getText());
								
								//Close the Setup window
								setupFrame.setVisible (false);
								setupFrame.dispose();
							}
						} else {
							//Create singleplayer remote object
							SinglePlayerFactoryIFC factory = (SinglePlayerFactoryIFC) reg
									.lookup("//" + serverIP + "/SinglePlayerFactory");
							final SinglePlayerServantIFC mmobj = factory.createGame();
							
							//Else Create mastermind single player game
							mmobj.newGame(numAttempts, numBalls, numColors);
							
							//Create the new game board
							new Board<SinglePlayerServantIFC>(SINGLEPLAYER, numAttempts, numBalls, numColors, mmobj, "");
							
							//Close the Setup window
							setupFrame.setVisible (false);
							setupFrame.dispose();
						}
					} catch (Exception ex) {
						ex.printStackTrace();
						JOptionPane.showMessageDialog(setupFrame, "-Error creating game!\nEnsure you entered the correct server IP\n-Check your network connection.\n-Server may be down.", "AHH!", JOptionPane.ERROR_MESSAGE);
					}
				}
			}
		});
		constraints.gridx = 0;
		constraints.gridy = constraints.gridy+1;
		constraints.gridwidth = 2;
		setupPanel.add(createButton, constraints);
		
		//The Back Button
		JButton backButton = new JButton("Back");
		backButton.setPreferredSize(new Dimension(100,30));
		backButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				//Go back to the main menu
				new MainMenu();
				setupFrame.setVisible (false);
				setupFrame.dispose();
			}
		});
		constraints.gridx = 0;
		constraints.gridy = constraints.gridy+1;
		constraints.gridwidth = 2;
		setupPanel.add(backButton, constraints);
		constraints.gridwidth = 1; //Reset gridwidth
		
		//Difficulty combobBox event handler
		difficultyComboBox.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                //Get the value that was selected
            	String selectedValue = difficultyComboBox.getSelectedItem().toString();
            	
            	//Lock all comboboxes
            	numAttemptsComboBox.setEnabled(false);
            	numBallsComboBox.setEnabled(false);
            	numColorsComboBox.setEnabled(false);
            	
            	//Determine the value that was selected
            	if(selectedValue=="Easy") {
            		//Set the three comboboxes
            		numAttemptsComboBox.setSelectedItem(EASYATTEMPTS);
            		numBallsComboBox.setSelectedItem(EASYBALLS);
            		numColorsComboBox.setSelectedItem(EASYCOLORS);
            	} else if(selectedValue=="Normal") {
            		//Set the three comboboxes
            		numAttemptsComboBox.setSelectedItem(NORMALATTEMPTS);
            		numBallsComboBox.setSelectedItem(NORMALBALLS);
            		numColorsComboBox.setSelectedItem(NORMALCOLORS);
            	} else if(selectedValue=="Hard") {
            		//Set the three comboboxes
            		numAttemptsComboBox.setSelectedItem(HARDATTEMPTS);
            		numBallsComboBox.setSelectedItem(HARDBALLS);
            		numColorsComboBox.setSelectedItem(HARDCOLORS);
            	} else if(selectedValue=="Custom") {
            		//Unlock all comboboxes
            		numAttemptsComboBox.setEnabled(true);
                	numBallsComboBox.setEnabled(true);
                	numColorsComboBox.setEnabled(true);
            	}
            }
        });
		
		//Borderless window
		setupFrame.setUndecorated(true);
    	
		//Resize the window
		setupFrame.pack();
		
		//Display the window
		setupFrame.setVisible(true);
	}
	
	public static Registry getRegistry(String hostip) throws RemoteException {
		try {
			return LocateRegistry.getRegistry(hostip, Registry.REGISTRY_PORT);
		} catch (Exception e) {
			return LocateRegistry.createRegistry(Registry.REGISTRY_PORT);
		}
	}
	
	public void mousePressed(MouseEvent me) {
		pressed = me;
	}
 
	public void mouseClicked(MouseEvent e) {}
	public void mouseReleased(MouseEvent e) {}
 
	public void mouseDragged(MouseEvent me) {
		location = setupFrame.getLocation(location);
		int x = location.x - pressed.getX() + me.getX();
		int y = location.y - pressed.getY() + me.getY();
		setupFrame.setLocation(x, y);
	 }
 
	public void mouseMoved(MouseEvent e) {}
	public void mouseEntered(MouseEvent e) {}
	public void mouseExited(MouseEvent e) {}
}