package clientPkg;

import java.awt.*;
import java.awt.event.*;
import java.rmi.*;
import java.rmi.registry.*;
import interfacePkg.*;

import javax.swing.*;

public class Waiting implements Constants, MouseListener, MouseMotionListener {
	private final JFrame waitingFrame;
	private Point location;
	private MouseEvent pressed;
	private String playerName;
	
	public Waiting(final int numAttempts, final int numBalls, final int numColors, final MultiPlayerServantIFC mmobj, String pn) {
		playerName = pn;
		
		//Setup the top level frame (window)
		waitingFrame = new JFrame("Mastermind - Waiting");
		
		//Add mouse listeners
		waitingFrame.addMouseListener(this);
		waitingFrame.addMouseMotionListener(this);
		
		//Set the default close operation
		waitingFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		
		//Set the size of the frame
		waitingFrame.setPreferredSize(new Dimension(WAITINGWIDTH,WAITINGHEIGHT));
		
		//Set the location of the frame
		waitingFrame.setLocation(WAITINGSTARTX,WAITINGSTARTY);
		
		//Disable resizing of frame
		waitingFrame.setResizable(false);
    	
		//Create the WaitingPanel
		JPanel waitingPanel = new JPanel();
		waitingPanel.setBackground(new Color(RCOLOR, GCOLOR, BCOLOR));
		waitingPanel.setPreferredSize(new Dimension(WAITINGWIDTH,WAITINGHEIGHT));
		waitingFrame.getContentPane().add(waitingPanel);
		
		//Wait Label
		JLabel waitLabel = new JLabel("<html><center><h3>Waiting For Another<br>Player To Join...</h3></center></html>");
		waitLabel.setPreferredSize(new Dimension(150,75));
		waitingPanel.add(waitLabel, waitLabel);
		
		//Wait for another player thread...
		final WaitThread wt = new WaitThread(numAttempts, numBalls, numColors, mmobj, waitingFrame);
		wt.start();
		
		//Cancel Button
		JButton cancelButton = new JButton("Cancel");
		cancelButton.setPreferredSize(new Dimension(100,30));
		cancelButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				//Stop the waitThread
				wt.closeThread();
				
				try {
					//Remove the game
					mmobj.removeGame();
				} catch (Exception ex) {
					System.out.println("Error removing game!");
				}
				
				//Go back to the main menu
				new MainMenu();
				waitingFrame.setVisible (false);
				waitingFrame.dispose();
			}
		});
		waitingPanel.add(cancelButton);
		
		//Borderless window
		waitingFrame.setUndecorated(true);
    	
		//Resize the window
		waitingFrame.pack();
		
		//Display the window
		waitingFrame.setVisible(true);
	}
	
	public static Registry getRegistry(String hostip) throws RemoteException {
		try {
			return LocateRegistry.getRegistry(hostip, Registry.REGISTRY_PORT);
		} catch (Exception e) {
			return LocateRegistry.createRegistry(Registry.REGISTRY_PORT);
		}
	}
	
	//Wait Thread Class -Used to run an infinate loop until another player joins
	class WaitThread extends Thread {
		int numAttempts;
		int numBalls;
		int numColors;
		MultiPlayerServantIFC mmobj;
		JFrame waitingFrame;
		boolean loop;
		
		public WaitThread(final int na, final int nb, final int nc, final MultiPlayerServantIFC mo, JFrame wf) {
			numAttempts = na;
			numBalls = nb;
			numColors = nc;
			mmobj = mo;
			waitingFrame = wf;
			loop = true;
		}
		
		public void closeThread() {
			loop = false;
		}

		public void run() {
			while(loop) {
	    		try {
	        		//Check if game is ready to start
	    			if(mmobj.checkStart()) {
	    				//Create the board
	    				Board<MultiPlayerServantIFC> b = new Board<MultiPlayerServantIFC>(MULTIPLAYER, numAttempts, numBalls, numColors, mmobj, playerName);
	                	
	                	waitingFrame.setVisible (false);
	    				waitingFrame.dispose();
	    				break;
	    			}
	    			Thread.sleep(100);
	    		} catch(Exception e) {
	    			e.printStackTrace();
	    			System.exit(0);
	    		}
			}
		}
	}
	
	public void mousePressed(MouseEvent me) {
		pressed = me;
	}
 
	public void mouseClicked(MouseEvent e) {}
	public void mouseReleased(MouseEvent e) {}
 
	public void mouseDragged(MouseEvent me) {
		location = waitingFrame.getLocation(location);
		int x = location.x - pressed.getX() + me.getX();
		int y = location.y - pressed.getY() + me.getY();
		waitingFrame.setLocation(x, y);
	 }
 
	public void mouseMoved(MouseEvent e) {}
	public void mouseEntered(MouseEvent e) {}
	public void mouseExited(MouseEvent e) {}
}