package interfacePkg;

public interface Constants {
	//Server Setup
	public static int MAXMULTIPLAYERGAMES = 8;
	
	//Game Constraints
	public static int MINATTEMPTS = 1;
	public static int MAXATTEMPTS = 16;
	public static int MINBALLS = 1;
	public static int MAXBALLS = 10;
	public static int MINCOLORS = 1;
	public static int MAXCOLORS = 9;
	
	//Game Difficulties
	public static int EASYATTEMPTS = 6;
	public static int EASYBALLS = 4;
	public static int EASYCOLORS = 4;
	public static int NORMALATTEMPTS = 8;
	public static int NORMALBALLS = 4;
	public static int NORMALCOLORS = 6;
	public static int HARDATTEMPTS = 12;
	public static int HARDBALLS = 6;
	public static int HARDCOLORS = 8;
	
	//End States
	public static int RESUME = 0;
	public static int WIN = 1;
	public static int LOSE = 2;
	public static int TIE = 3;
	
	//Event Viewer
	public static int EVENTVIEWERWIDTH = 550;
	public static int EVENTVIEWERHEIGHT = 125;
	public static int EVENTVIEWERSTARTX = 0;
	public static int EVENTVIEWERSTARTY = 0;
	
	//Game Types
	public static int SINGLEPLAYER = 0;
	public static int MULTIPLAYER = 1;
	
	//Player Boards
	public static int PLAYERBOARD = 0;
	public static int OPPONENTBOARD = 1;
	public static int PLAYERNOTWAITING = 0;
	public static int PLAYERWAITING = 1;

	//Menu Setup
	public static int MENUWIDTH = 258;
	public static int MENUHEIGHT = 585;
	public static int MENUSTARTX = 400;
	public static int MENUSTARTY = 10;
	public static int MENUBUTTONWIDTH = 185;
	public static int MENUBUTTONHEIGHT = 30;
	public static String MENULOGO = "../imagePkg/Logo.png";
	
	//Setup Window Settings
	public static int SETTINGSWIDTH = 250;
	public static int SETTINGSHEIGHT = 275;
	public static int SETTINGSSTARTX = 400;
	public static int SETTINGSSTARTY = 200;
	
	//Waiting Window Setup
	public static int WAITINGWIDTH = 250;
	public static int WAITINGHEIGHT = 150;
	public static int WAITINGSTARTX = 400;
	public static int WAITINGSTARTY = 200;
	
	//Board Setup
	public static int BOARDWIDTH = 250;
	public static int MINBOARDHEIGHT = 625;
	public static int BOARDSTARTX = 400;
	public static int BOARDSTARTY = 10;
	public static int RCOLOR = 205;
	public static int GCOLOR = 133;
	public static int BCOLOR = 63;
	
	//Ball Setup
	public static int BALLWIDTH = 23;
	public static int BALLHEIGHT = 23;
	
	//Ball Colors
	public static int CLEAR = 0;
	public static int BLUE = 1;
	public static int RED = 2;
	public static int GREEN = 3;
	public static int BLACK = 4;
	public static int YELLOW = 5;
	public static int ORANGE = 6;
	public static int SILVER = 7;
	public static int WHITE = 8;
	public static int PURPLE = 9;
	
	//Ball States
	public static int LOCKED = 0;
	public static int UNLOCKED = 1;
	
	//Ball Images
	public static String CLEARIMAGE = "../imagePkg/BallClear.png";
	public static String BLUEIMAGE = "../imagePkg/BallBlue.png";
	public static String REDIMAGE = "../imagePkg/BallRed.png";
	public static String GREENIMAGE = "../imagePkg/BallGreen.png";
	public static String BLACKIMAGE = "../imagePkg/BallBlack.png";
	public static String YELLOWIMAGE = "../imagePkg/BallYellow.png";
	public static String ORANGEIMAGE = "../imagePkg/BallOrange.png";
	public static String SILVERIMAGE = "../imagePkg/BallSilver.png";
	public static String WHITEIMAGE = "../imagePkg/BallWhite.png";
	public static String PURPLEIMAGE = "../imagePkg/BallPurple.png";
	
	//Peg Setup
	public static int PEGWIDTH = 8;
	public static int PEGHEIGHT = 8;
	
	//Peg States
	public static int MISS = 0;
	public static int HIT = 1;
	public static int CLOSE = 2;
	
	//Peg Images
	public static String MISSIMAGE = "../imagePkg/PegMiss.png";
	public static String HITIMAGE = "../imagePkg/PegHit.png";
	public static String CLOSEIMAGE = "../imagePkg/PegClose.png";
}
