package interfacePkg;

import java.rmi.*;
import serverPkg.*;

public interface MultiPlayerServantIFC extends Remote, SinglePlayerServantIFC {
	public void newGame(int reqAttempts, int reqBalls, int reqColors) throws RemoteException;
	public void submitAttempt(String pn, int currentAttempt, int[] attempt) throws RemoteException;
	public int[] receiveResult(String pn) throws RemoteException;
	public boolean checkReceive() throws RemoteException;
	public int[] revealAttempt(String pn, int attemptNum) throws RemoteException;
	public int checkEndGame(String pn, int currentAttempt) throws RemoteException;
	public void startGame() throws RemoteException;
	public void removeGame() throws RemoteException;
	public boolean checkStart() throws RemoteException;
	public void setExit(String pn) throws RemoteException;
	public boolean checkExit(String pn) throws RemoteException;
	public boolean setPlayerName(String pn) throws RemoteException;
	public int getNumAttempts() throws RemoteException;
	public int getNumBalls() throws RemoteException;
	public int getNumColors() throws RemoteException;
	public String getOpponentName(String pn) throws RemoteException;
	public void sendMessage(String m, String pn) throws RemoteException;
	public String receiveMessage(String pn) throws RemoteException;
	public int getPlayerStatus(String on) throws RemoteException;
}
