package serverPkg;

import interfacePkg.*;
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.text.*;
import java.net.*;
import java.io.*;
import java.nio.*;
import java.util.*;

public class EventViewer extends Thread implements Constants, MouseListener, MouseMotionListener, ActionListener {
	private Point location;
	private MouseEvent pressed;
	private JTextArea eventHistory;
	private JScrollPane scrollPane;
	private JMenuItem clearItem;
	private JMenuItem aboutItem;
	private JMenuItem exitItem;
	private JMenuItem saveLogItem;
	private JFrame eventFrame;
	private RegistryControl rc;
	
	public void run() {
		//Creat the event frame
		eventFrame = new JFrame("Event Frame");
		
		//Add mouse listeners
		eventFrame.addMouseListener(this);
		eventFrame.addMouseMotionListener(this);
		
		//Set the default close operation
		eventFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		
		//Set the size of the frame
		eventFrame.setPreferredSize(new Dimension(EVENTVIEWERWIDTH, EVENTVIEWERHEIGHT+40));
		
		//Set the location of the frame
		eventFrame.setLocation(EVENTVIEWERSTARTX,EVENTVIEWERSTARTY);
		
		//Create the eventPanel
		JPanel eventPanel = new JPanel();
		eventFrame.getContentPane().add(eventPanel);
		
		//Create the JTextArea
		eventHistory = new JTextArea();
		//eventHistory.setPreferredSize(new Dimension(EVENTVIEWERWIDTH, EVENTVIEWERHEIGHT-25));
		eventHistory.setEditable(false);
		
		//Create a scrollpane to make the text area scrollable
		scrollPane = new JScrollPane(eventHistory);
		scrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
		scrollPane.setPreferredSize(new Dimension(EVENTVIEWERWIDTH,EVENTVIEWERHEIGHT-25));
		
		//Add scroll pane to eventFrame
		eventPanel.add(scrollPane);
		
		//List Network Devices
		final JComboBox interfacesComboBox = new JComboBox();
		interfacesComboBox.addItem("Interface: localhost <> IP Address: localhost");
		try {
			Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
			
	        while(e.hasMoreElements()) {
	           NetworkInterface netface = (NetworkInterface)
	           e.nextElement();

	           Enumeration<InetAddress> e2 = netface.getInetAddresses();
	
	           while (e2.hasMoreElements()){
	              InetAddress ip = (InetAddress) e2.nextElement();
	              
	              String stringIP = ip.toString();
	              String ipAddress = stringIP.substring(stringIP.indexOf("/")+1);
	              
	              interfacesComboBox.addItem("Interface: "+netface.getName() + " <> IP Address: "+ipAddress);
	           }
	        }
		} catch (Exception e) {
			e.printStackTrace();
		}

		interfacesComboBox.setPreferredSize(new Dimension(EVENTVIEWERWIDTH-85,25));
		eventPanel.add(interfacesComboBox);
		
		writeLine("Select a network interface to bind the server to.");
		
		final EventViewer eventViewer = this;
		
		//Save button
		final JButton saveButton = new JButton("Save");
		saveButton.setPreferredSize(new Dimension(75,25));
		saveButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				//Get the ip address chosen
				String selectedItem = interfacesComboBox.getSelectedItem().toString();
				
				//Parse the item for the ip address
				String ipAddress = selectedItem.substring(selectedItem.indexOf("IP Address: ")+12);

				rc = new RegistryControl(eventViewer, ipAddress);
				
				saveButton.setEnabled(false);
				interfacesComboBox.setEnabled(false);
				
				writeLine("Bind Succussful! Waiting for requests on "+ipAddress+".");
			}
		});
		eventPanel.add(saveButton);
		
		//Setup the menu bar
		JMenuBar menuBar = new JMenuBar();
	    
	    // Create the menus for the menu bar
	    JMenu fileMenu = new JMenu("File");
	    JMenu editMenu = new JMenu("Edit");
	    JMenu helpMenu = new JMenu("?");
	    
	    //Add the menus to the menu bar
	    menuBar.add(fileMenu);
	    menuBar.add(editMenu);
	    menuBar.add(helpMenu);
	    
	    //Create the file menu items
	    exitItem = new JMenuItem("Exit");
	    exitItem.addActionListener(this);
	    fileMenu.add(exitItem);
	    
	    //Create the edit menu items
	    clearItem = new JMenuItem("Clear Screen");
	    clearItem.addActionListener(this);
	    editMenu.add(clearItem);
	    saveLogItem = new JMenuItem("Save Log");
	    saveLogItem.addActionListener(this);
	    editMenu.add(saveLogItem);
	    
	    //Create the ? menu items
	    aboutItem = new JMenuItem("About");
	    aboutItem.addActionListener(this);
	    helpMenu.add(aboutItem);
	    
	    //Install the menu bar in the frame
	    eventFrame.setJMenuBar(menuBar);

		//Borderless window
	    eventFrame.setUndecorated(true);
    	
		//Resize the window
	    eventFrame.pack();
		
		//Display the window
	    eventFrame.setVisible(true);
	}
	
	public void writeLine(String s) {
		//Get the date yy/mm/dd and the time kk:mm:ss
		Date d = new Date();
		SimpleDateFormat formater = new SimpleDateFormat("yy/MM/dd @ kk:mm:ss");

		//Check if this is the first line
		if(eventHistory.getDocument().getLength()==0) {
			eventHistory.append(formater.format(d) + " -->  " + s);
		} else {
			//get the text from the textArea and add the text to be inserted
			String text = eventHistory.getText();
			eventHistory.setText("");
			
			eventHistory.append(text + "\n" + formater.format(d) + " -->  " + s);
		}
		
		//Autoscroll the scrollPane to the bottom
		eventHistory.setCaretPosition(eventHistory.getDocument().getLength());
	}
	
	public void actionPerformed(ActionEvent e) {
		//Determine what action was perfmored
		if (e.getSource() == clearItem) {
			eventHistory.setText("");
		} else if (e.getSource() == aboutItem) {
			JOptionPane.showMessageDialog(eventFrame,"Programmed by Warren Brown & Brian Thai","ALERT",JOptionPane.NO_OPTION);
		} else if (e.getSource() == saveLogItem) {
			saveLogToFile();
		}else if (e.getSource() == exitItem) {
			System.exit(0);
		}
	}
	
	public void saveLogToFile() {
		//Get the date yy/mm/dd and the time kk:mm:ss
		Date d = new Date();
		SimpleDateFormat formater = new SimpleDateFormat("yy-MM-dd-kk-mm-ss");
		
	    try {
	    	String fileName = "Mastermind-" + formater.format(d) + ".log";
	        BufferedWriter out = new BufferedWriter(new FileWriter("logs/" + fileName));
	        out.write(eventHistory.getText());
	        out.close();
	        JOptionPane.showMessageDialog(eventFrame,"File saved as:\n" + fileName,"ALERT",JOptionPane.NO_OPTION);
	    } catch (Exception e) {
	    	e.printStackTrace();
	    	writeLine(e.toString());
	    	JOptionPane.showMessageDialog(eventFrame,"Could not save log file!","ALERT",JOptionPane.WARNING_MESSAGE);
	    }
	}
	
	public void mousePressed(MouseEvent me) {
		pressed = me;
	}
 
	public void mouseClicked(MouseEvent e) {}
	public void mouseReleased(MouseEvent e) {}
 
	public void mouseDragged(MouseEvent me) {
		location = eventFrame.getLocation(location);
		int x = location.x - pressed.getX() + me.getX();
		int y = location.y - pressed.getY() + me.getY();
		eventFrame.setLocation(x, y);
	}
 
	public void mouseMoved(MouseEvent e) {}
	public void mouseEntered(MouseEvent e) {}
	public void mouseExited(MouseEvent e) {}
}
