package serverPkg;

import java.rmi.*;
import java.rmi.server.*;
import interfacePkg.*;

public class MultiPlayerFactory extends UnicastRemoteObject implements
		MultiPlayerFactoryIFC, Constants {
	private MultiPlayerServant[] games;
	private EventViewer eventViewer;

	public MultiPlayerFactory(EventViewer ev) throws RemoteException {
		eventViewer = ev;
		games = new MultiPlayerServant[MAXMULTIPLAYERGAMES];
	}

	public MultiPlayerServantIFC createGame(String gameName)
			throws RemoteException {
		boolean foundGame = false;
		for (int i = 0; i < games.length; i++) {
			if (games[i] == null) {
			} else if (gameName.equals(games[i].getGameName())) {
				foundGame = true;
			}
		}
		if (foundGame == true) {
			return null;
		} else {
			MultiPlayerServant newGame = new MultiPlayerServant(gameName, this);
			for (int i = 0; i < games.length; i++) {
				if (games[i] == null) {
					games[i] = newGame;
					eventViewer.writeLine("New Game Created Called: "
							+ newGame.getGameName());
					break;
				}
			}
			return newGame;
		}
	}

	public MultiPlayerServantIFC joinGame(String gameName)
			throws RemoteException {
		MultiPlayerServant foundGame = null;
		for (int i = 0; i < games.length; i++) {
			if (games[i] == null) {
			} else if (gameName.equals(games[i].getGameName())
					&& !games[i].checkStart()) {
				foundGame = games[i];
				eventViewer.writeLine("A Player Joined: " + gameName);
				eventViewer.writeLine("The game " + gameName + " has begun!");
			}
		}
		return foundGame;
	}

	public void removeGame(String gameName) throws RemoteException {
		for (int i = 0; i < games.length; i++) {
			if (games[i] == null) {
			} else if (gameName.equals(games[i].getGameName())) {
				games[i] = null;
				eventViewer.writeLine("Game Destroyed: " + gameName);
			}
		}
	}
}
