package serverPkg;

import java.rmi.*;
import java.rmi.server.*;
import java.util.*;
import interfacePkg.*;

public class MultiPlayerServant extends UnicastRemoteObject implements
		MultiPlayerServantIFC {
	private MultiPlayerFactory factory;
	private Random rand = new Random();
	private Player player1;
	private Player player2;
	private String gameName;
	private int[] masterCode;
	private int totalAttempts;
	private int numColors;
	private int submittions;
	private int results;
	private boolean ready;
	private boolean running;
	private String exiter;
	private Chat chat;

	public MultiPlayerServant(String gn, MultiPlayerFactory f)
			throws RemoteException {
		factory = f;
		gameName = gn;
		player1 = new Player();
		player2 = new Player();
		totalAttempts = 0;
		numColors = 0;
		submittions = 0;
		results = 0;
		ready = false;
		running = true;
		exiter = "";
		chat = new Chat();
	}

	public void newGame(int reqAttempts, int reqBalls, int reqColors)
			throws RemoteException {
		totalAttempts = reqAttempts;
		numColors = reqColors;
		masterCode = new int[reqBalls];
		player1.preparePlayer(reqBalls, reqAttempts);
		player2.preparePlayer(reqBalls, reqAttempts);
		generateCode(reqBalls, reqColors);
	}

	public void startGame() throws RemoteException {
		ready = true;
	}

	public void removeGame() throws RemoteException {
		factory.removeGame(gameName);
	}

	public boolean checkStart() throws RemoteException {
		return ready;
	}
	
	public void setExit(String pn) throws RemoteException {
		exiter = pn;
		running = false;
	}
	
	public boolean checkExit(String pn) throws RemoteException {
		if (exiter.equals(pn)) {
			return false;
		}
		return running;
	}

	public void submitAttempt(String pn, int currentAttempt, int[] attempt)
			throws RemoteException {
		while (submittions == 2) {

		}
		if (player1.getName().equals(pn)) {
			player1.setStatus(1);
			player1.setAttempt(currentAttempt, attempt, totalAttempts);

		} else {
			player2.setStatus(1);
			player2.setAttempt(currentAttempt, attempt, totalAttempts);
		}
		testAttempt(pn, currentAttempt);
		submittions++;
	}

	public int[] receiveResult(String pn) throws RemoteException {
		results++;
		if (player1.getName().equals(pn)) {
			if (results == 4) {
				submittions = 0;
				results = 0;
			}
			player1.setStatus(0);
			return player1.getSortedPegs();
		} else {
			if (results == 4) {
				submittions = 0;
				results = 0;
			}
			player2.setStatus(0);
			return player2.getSortedPegs();
		}
	}

	public boolean checkReceive() throws RemoteException {
		if (submittions == 2) {
			return true;
		} else {
			return false;
		}
	}
	
	public int[] revealAttempt(String pn, int attemptNum) throws RemoteException {
		if (player2.getName().equals(pn)) {
			return player2.getAttempt(attemptNum);
		} else {
			return player1.getAttempt(attemptNum);
		}
	}

	public int checkEndGame(String pn, int currentAttempt)
			throws RemoteException {
		int endStatus = 0;
		if (checkWin(pn)) {
			endStatus = 1;
		} else if (checkLose(pn)) {
			endStatus = 2;
		} else if (checkTie(currentAttempt)) {
			endStatus = 3;
		}
		return endStatus;
	}

	public boolean checkWin(String pn) {
		if (player1.getName().equals(pn)) {
			if ((player1.getHits() == masterCode.length)
					&& (player2.getHits() != masterCode.length)) {
				return true;
			} else {
				return false;
			}
		} else {
			if ((player2.getHits() == masterCode.length)
					&& (player1.getHits() != masterCode.length)) {
				return true;
			} else {
				return false;
			}
		}
	}

	public boolean checkLose(String pn) {
		if (player1.getName().equals(pn)) {
			if ((player2.getHits() == masterCode.length)
					&& (player1.getHits() != masterCode.length)) {
				return true;
			} else {
				return false;
			}
		} else {
			if ((player1.getHits() == masterCode.length)
					&& (player2.getHits() != masterCode.length)) {
				return true;
			} else {
				return false;
			}
		}
	}

	public boolean checkTie(int currentAttempt) {
		if ((currentAttempt + 1 == totalAttempts)
				|| (player1.getHits() == masterCode.length && player2.getHits() == masterCode.length)) {
			return true;
		} else {
			return false;
		}
	}

	public boolean setPlayerName(String pn) throws RemoteException {
		if (player1.getName().equals("")) {
			player1.setName(pn);
			return true;
		} else if (player1.getName().equals(pn)) {
			return false;
		} else {
			player2.setName(pn);
			return true;
		}
	}

	public int getNumAttempts() throws RemoteException {
		return totalAttempts;
	}

	public int getNumBalls() throws RemoteException {
		return masterCode.length;
	}

	public int getNumColors() throws RemoteException {
		return numColors;
	}

	public String getOpponentName(String pn) throws RemoteException {
		if (player1.getName().equals(pn)) {
			return player2.getName();
		} else {
			return player1.getName();
		}
	}

	private void generateCode(int balls, int colors) {
		//String stringCode = "";
		for (int i = 0; i < balls; i++) {
			masterCode[i] = rand.nextInt(colors) + 1;
			//stringCode = stringCode + masterCode[i];
		}
		//System.out.println(stringCode);
	}

	private void testAttempt(String pn, int currentAttempt) {
		if (player1.getName().equals(pn)) {
			player1.setHits(0);
			player1.setCloses(0);
			player1.setCopyCode(masterCode);
		} else {
			player2.setHits(0);
			player2.setCloses(0);
			player2.setCopyCode(masterCode);
		}
		for (int i = 0; i < masterCode.length; i++) {
			testHits(pn, i);
		}
		for (int i = 0; i < masterCode.length; i++) {
			testCloses(pn, i);
		}
		sortPegs(pn);
	}

	private void testHits(String pn, int index) {
		if (player1.getName().equals(pn)) {
			if (player1.getAttemptValue(index) == player1
					.getCopyCode(index)) {
				player1.setHits(player1.getHits() + 1);
				player1.updateAttemptValue(index);
				player1.updateCopyCode(index);
			}
		} else {
			if (player2.getAttemptValue(index) == player2
					.getCopyCode(index)) {
				player2.setHits(player2.getHits() + 1);
				player2.updateAttemptValue(index);
				player2.updateCopyCode(index);
			}
		}
	}

	private void testCloses(String pn, int index) {
		boolean foundClose = false;
		if (player1.getName().equals(pn)) {
			for (int i = 0; i < masterCode.length; i++) {
				if (player1.getAttemptValue(index) == player1
						.getCopyCode(i)) {
					foundClose = true;
					player1.updateAttemptValue(index);
					player1.updateCopyCode(i);
					i = masterCode.length;
				}
			}
			if (foundClose == true) {
				player1.setCloses(player1.getCloses() + 1);
			}
		} else {
			for (int i = 0; i < masterCode.length; i++) {
				if (player2.getAttemptValue(index) == player2
						.getCopyCode(i)) {
					foundClose = true;
					player2.updateAttemptValue(index);
					player2.updateCopyCode(i);
					i = masterCode.length;
				}
			}
			if (foundClose == true) {
				player2.setCloses(player2.getCloses() + 1);
			}
		}
	}

	public void sortPegs(String pn) {
		if (player1.getName().equals(pn)) {
			for (int i = 0; i < masterCode.length; i++) {
				player1.setSortedPegs(i, 0);
			}
			for (int i = 0; i < player1.getHits(); i++) {
				player1.setSortedPegs(i, 1);
			}
			for (int i = player1.getHits(); i < (player1.getHits() + player1
					.getCloses()); i++) {
				player1.setSortedPegs(i, 2);
			}
		} else {
			for (int i = 0; i < masterCode.length; i++) {
				player2.setSortedPegs(i, 0);
			}
			for (int i = 0; i < player2.getHits(); i++) {
				player2.setSortedPegs(i, 1);
			}
			for (int i = player2.getHits(); i < (player2.getHits() + player2
					.getCloses()); i++) {
				player2.setSortedPegs(i, 2);
			}
		}
	}

	public String getGameName() {
		return gameName;
	}

	// Required by interface
	public int[] receiveResult() throws RemoteException {
		return null;
	}

	public void submitAttempt(int[] attempt) {
	}

	public boolean checkLose() throws RemoteException {
		return false;
	}

	public boolean checkWin() throws RemoteException {
		return false;
	}

	public int checkEndGame() throws RemoteException {
		return 0;
	}
	
	public int[] getMasterCode() throws RemoteException {
		return masterCode;
	}
	
	public void sendMessage(String m, String pn) throws RemoteException {
		chat.addMessage(m, pn);
	}
	
	public String receiveMessage(String pn) throws RemoteException {
		if (player1.getName().equals(pn)) {
			return chat.getPlayer1Message();
		} else {
			return chat.getPlayer2Message();
		}
	}
	
	public int getPlayerStatus(String on) throws RemoteException {
		if (player1.getName().equals(on)) {
			return player1.getStatus();
		} else {
			return player2.getStatus();
		}
	}
}
