package serverPkg;

public class Player {
	private String name;
	private int[] copyCode;
	private int[] sortedPegs;
	private int hits;
	private int closes;
	private int[] attemptCode;
	private int[][] attemptRecord;
	private int status;
	
	public Player() {
		name = "";
		hits = 0;
		closes = 0;
		status = 0;
	}
	
	public void preparePlayer(int reqBalls, int reqAttempts) {
		copyCode = new int[reqBalls];
		attemptCode = new int[reqBalls];
		sortedPegs = new int[reqBalls];
		attemptRecord = new int[reqAttempts][reqBalls + 1];
		for (int i = 0; i < reqAttempts; i++) {
			for (int j = 0; i < reqBalls + 1; i++) {
				attemptRecord[i][j] = 0;
			}
		}
	}
	
	public void setName(String n) {
		name = n;
	}
	
	public void setHits(int h) {
		hits = h;
	}
	
	public void setCloses(int c) {
		closes = c;
	}
	
	public void setCopyCode(int[] code) {
		for (int i = 0; i < code.length; i++) {
			copyCode[i] = code[i];
		}
	}
	
	public void setAttempt(int currentAttempt, int[] attempt, int totalAttempts) {
		attemptRecord[currentAttempt][0] = currentAttempt;
		for (int i = 0; i < attempt.length; i++) {
			attemptRecord[currentAttempt][i + 1] = attempt[i];
			attemptCode[i] = attempt[i];
		}
	}
	
	public void updateAttemptValue(int index) {
		attemptCode[index] = -1;
	}
	
	public void setSortedPegs(int index, int value) {
		sortedPegs[index] = value;
	}
	
	public void updateCopyCode(int index) {
		copyCode[index] = 0;
	}
	
	public String getName() {
		return name;
	}
	
	public int getHits() {
		return hits;
	}
	
	public int getCloses() {
		return closes;
	}
	
	public int getCopyCode(int index) {
		return copyCode[index];
	}
	
	public int[] getAttempt(int attemptNum) {
		int[] attempt = new int[copyCode.length];
		for (int i = 0; i < copyCode.length; i++) {
			attempt[i] = attemptRecord[attemptNum][i + 1];
		}
		return attempt;
	}
	
	public int getAttemptValue(int index) {
		return attemptCode[index];
	}
	
	public int[] getSortedPegs() {
		return sortedPegs;
	}
	
	public void setStatus(int s) {
		status = s;
	}
	
	public int getStatus() {
		return status;
	}	
}
