package serverPkg;

import interfacePkg.MultiPlayerFactoryIFC;
import interfacePkg.SinglePlayerFactoryIFC;
import java.net.*;
import java.io.*;
import java.nio.*;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.*;

public class RegistryControl {
	public RegistryControl(EventViewer eventViewer, String ipAddress) {
		try {	
			Registry serverReg = getRegistry(ipAddress);
			SinglePlayerFactoryIFC singlePlayerfactory = new SinglePlayerFactory(eventViewer);
			MultiPlayerFactoryIFC multiPlayerfactory = new MultiPlayerFactory(eventViewer);
			
			//Bind the SinglePlayerFactor to the registry
			String objname = "//" + ipAddress + "/SinglePlayerFactory";
			serverReg.rebind(objname, singlePlayerfactory);
			
			//Bind the MultiPlayerFactor to the registry
			objname = "//" + ipAddress + "/MultiPlayerFactory";
			serverReg.rebind(objname, multiPlayerfactory);
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}
	
	private static Registry getRegistry(String hostip) throws RemoteException {
		try {
			return LocateRegistry.createRegistry(Registry.REGISTRY_PORT);
		} catch (RuntimeException e) {
			return LocateRegistry.getRegistry(hostip, Registry.REGISTRY_PORT);
		}
	}
}
