package serverPkg;

import java.rmi.*;
import java.rmi.registry.*;
import interfacePkg.*;
import java.net.*;
import java.io.*;
import java.nio.*;
import java.util.*;

public class Server implements Constants {
	private String hostname;
	private String ipAddress;

	public Server(String[] args) {
		if (args.length > 0) {
			hostname = args[0];
		}
		
		//Display eventViewer gui
		EventViewer eventViewer = new EventViewer();
		eventViewer.start();
	}

	public static Registry getRegistry(String hostip) throws RemoteException {
		try {
			return LocateRegistry.createRegistry(Registry.REGISTRY_PORT);
		} catch (RuntimeException e) {
			return LocateRegistry.getRegistry(hostip, Registry.REGISTRY_PORT);
		}
	}

	public static void main(String[] args) {
		new Server(args);
	}
}
