package serverPkg;

import java.rmi.*;
import java.rmi.server.*;
import java.util.*;
import interfacePkg.*;

public class SinglePlayerServant extends UnicastRemoteObject implements
		SinglePlayerServantIFC {
	private Random rand = new Random();
	private int[] masterCode;
	private int[] attemptedCode;
	private int[] copyCode;
	private int attemptsLeft;
	private int hits;
	private int closes;

	public SinglePlayerServant() throws RemoteException {
		attemptsLeft = 0;
		hits = 0;
		closes = 0;
	}

	public void newGame(int reqAttempts, int reqBalls, int reqColors)
			throws RemoteException {
		attemptsLeft = reqAttempts;
		masterCode = new int[reqBalls];
		attemptedCode = new int[reqBalls];
		copyCode = new int[reqBalls];
		generateCode(reqBalls, reqColors);
	}

	public void submitAttempt(int[] attempt) throws RemoteException {
		for (int i = 0; i < masterCode.length; i++) {
			attemptedCode[i] = attempt[i];
		}
		testAttempt();
	}

	public int[] receiveResult() throws RemoteException {
		return sortPegs();
	}
	
	public int checkEndGame() throws RemoteException {
		int endStatus = 0;
		if (checkWin()) {
			endStatus = 1;
		} else if (checkLose()) {
			endStatus = 2;
		}
		return endStatus;
	}

	public boolean checkWin() {
		if (hits == masterCode.length) {
			resetPegs();
			return true;
		} else {
			resetPegs();
			return false;
		}
	}

	public boolean checkLose() {
		if (attemptsLeft <= 0) {
			return true;
		} else {
			return false;
		}
	}

	private void generateCode(int balls, int colors) {
		//String stringCode = "";
		for (int i = 0; i < balls; i++) {
			masterCode[i] = rand.nextInt(colors) + 1;
			//stringCode = stringCode + masterCode[i];
		}
		//System.out.println(stringCode);
	}

	private void testAttempt() {
		for (int i = 0; i < masterCode.length; i++) {
			copyCode[i] = masterCode[i];
		}
		for (int i = 0; i < masterCode.length; i++) {
			testHits(i);
		}
		for (int i = 0; i < masterCode.length; i++) {
			testCloses(i);
		}
		attemptsLeft--;
	}

	private void testHits(int index) {
		if (attemptedCode[index] == copyCode[index]) {
			hits++;
			attemptedCode[index] = -1;
			copyCode[index] = 0;
		}
	}

	private void testCloses(int index) {
		boolean foundClose = false;
		for (int i = 0; i < masterCode.length; i++) {
			if ((attemptedCode[index] == copyCode[i])) {
				foundClose = true;
				attemptedCode[index] = -1;
				copyCode[i] = 0;
				i = masterCode.length;
			}
		}
		if (foundClose == true) {
			closes++;
		}
	}

	public int[] sortPegs() {
		int[] sortedPegs = new int[masterCode.length];
		for (int i = 0; i < masterCode.length; i++) {
			sortedPegs[i] = 0;
		}
		for (int i = 0; i < hits; i++) {
			sortedPegs[i] = 1;
		}
		for (int i = hits; i < (hits + closes); i++) {
			sortedPegs[i] = 2;
		}
		return sortedPegs;
	}

	public void resetPegs() {
		hits = 0;
		closes = 0;
	}
	
	public int[] getMasterCode() throws RemoteException {
		return masterCode;
	}
}
